/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.output.AbstractDistribOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;
import fr.ird.osmose.process.mortality.MortalityCause;
import java.io.File;

public class MortalitySpeciesOutput
extends AbstractDistribOutput {
    private final Species species;
    private double[] abundanceStage;
    private double[][] mortalityRates;

    public MortalitySpeciesOutput(int rank, Species species, AbstractDistribution distrib) {
        super(rank, distrib);
        this.species = species;
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("Mortality");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_mortalityRateDistribBy");
        filename.append(this.getType().toString());
        filename.append("-");
        filename.append(this.species.getName());
        filename.append("_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "Predation (Mpred), Starvation (Mstarv), Other Natural mortality (Mnat), Fishing (F) & Out-of-domain (Z) mortality rates per time step of saving and per size class. Z is the total mortality for migratory fish outside the simulation grid. To get annual mortality rates, sum the mortality rates within one year.";
    }

    @Override
    public void reset() {
        this.mortalityRates = new double[MortalityCause.values().length][this.getNClass()];
    }

    @Override
    public void update() {
        int iClass;
        int nCause = MortalityCause.values().length;
        double[][] nDead = new double[nCause][this.getNClass()];
        for (School school : this.getSchoolSet()) {
            if (school.getSpeciesIndex() != this.species.getIndex()) continue;
            iClass = this.getClass(school);
            for (MortalityCause cause : MortalityCause.values()) {
                double[] dArray = nDead[cause.index];
                int n = iClass;
                dArray[n] = dArray[n] + school.getNdead(cause);
            }
        }
        for (iClass = 0; iClass < this.getNClass(); ++iClass) {
            if (!(this.abundanceStage[iClass] > 0.0)) continue;
            double nDeadTot = 0.0;
            for (int iDeath = 0; iDeath < nCause; ++iDeath) {
                nDeadTot += nDead[iDeath][iClass];
            }
            double Z = Math.log(this.abundanceStage[iClass] / (this.abundanceStage[iClass] - nDeadTot));
            for (int iDeath = 0; iDeath < nCause; ++iDeath) {
                double[] dArray = this.mortalityRates[iDeath];
                int n = iClass;
                dArray[n] = dArray[n] + Z * nDead[iDeath][iClass] / nDeadTot;
            }
        }
    }

    @Override
    public void write(float time) {
        int nCause = MortalityCause.values().length;
        double[][] array = new double[this.getNClass()][nCause + 1];
        for (int iClass = 0; iClass < this.getNClass(); ++iClass) {
            array[iClass][0] = this.getClassThreshold(iClass);
            for (int iDeath = 0; iDeath < nCause; ++iDeath) {
                array[iClass][iDeath + 1] = this.mortalityRates[iDeath][iClass];
            }
        }
        this.writeVariable(time, array);
    }

    @Override
    String[] getHeaders() {
        return new String[]{this.getType().toString(), "Mpred", "Mstar", "Mnat", "F", "Z"};
    }

    @Override
    public void initStep() {
        this.abundanceStage = new double[this.getNClass()];
        for (School school : this.getSchoolSet().getSchools(this.species, false)) {
            int iClass = this.getClass(school);
            if (iClass < 0) continue;
            int n = iClass;
            this.abundanceStage[n] = this.abundanceStage[n] + school.getAbundance();
        }
    }
}

