/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.logging;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SimulationLogFormatter
extends Formatter {
    private final int rank;

    public SimulationLogFormatter(int rank) {
        this.rank = rank;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("  simulation#");
        builder.append(this.rank);
        builder.append("[").append(record.getLevel().toString().toLowerCase()).append("] - ");
        builder.append(this.formatMessage(record));
        if (null != record.getThrown()) {
            builder.append(" | ");
            if (null != record.getThrown()) {
                builder.append(record.getThrown().getClass().getName());
                builder.append(" ");
            }
            builder.append(record.getThrown().getMessage());
        }
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public String getHead(Handler h) {
        return super.getHead(h);
    }

    @Override
    public String getTail(Handler h) {
        return super.getTail(h);
    }
}

