/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.util.timeseries.ByClassTimeSeries;

public class IncomingFluxProcess
extends AbstractProcess {
    private double[][][] biomassIn;
    private float[][] lengthIn;
    private int[][] ageIn;

    public IncomingFluxProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int nSpecies = this.getConfiguration().getNSpecies();
        this.biomassIn = new double[nSpecies][][];
        this.lengthIn = new float[nSpecies][];
        this.ageIn = new int[nSpecies][];
        for (int iSpec = 0; iSpec < nSpecies; ++iSpec) {
            if (!this.getConfiguration().isNull("flux.incoming.byDt.byAge.file.sp" + iSpec)) {
                ByClassTimeSeries timeSerieByAge = new ByClassTimeSeries(this.getRank());
                timeSerieByAge.read(this.getConfiguration().getFile("flux.incoming.byDt.byAge.file.sp" + iSpec));
                this.biomassIn[iSpec] = timeSerieByAge.getValues();
                this.ageIn[iSpec] = new int[timeSerieByAge.getNClass()];
                for (int iAge = 0; iAge < this.ageIn[iSpec].length - 1; ++iAge) {
                    this.ageIn[iSpec][iAge] = (int)((double)this.getConfiguration().getNStepYear() * (0.5 * (double)(timeSerieByAge.getClass(iAge) + timeSerieByAge.getClass(iAge + 1))));
                }
                int lifespan = this.getSpecies(iSpec).getLifespanDt();
                this.ageIn[iSpec][this.ageIn[iSpec].length - 1] = (int)(0.5 * (double)((float)this.getConfiguration().getNStepYear() * timeSerieByAge.getClass(this.ageIn[iSpec].length - 1) + (float)lifespan));
                this.lengthIn[iSpec] = new float[timeSerieByAge.getNClass()];
                for (int iAge = 0; iAge < this.ageIn[iSpec].length; ++iAge) {
                    this.lengthIn[iSpec][iAge] = this.getSpecies(iSpec).computeMeanLength(this.ageIn[iSpec][iAge]);
                }
                continue;
            }
            if (this.getConfiguration().isNull("flux.incoming.byDt.bySize.file.sp" + iSpec)) continue;
            ByClassTimeSeries timeSerieBySize = new ByClassTimeSeries(this.getRank());
            timeSerieBySize.read(this.getConfiguration().getFile("flux.incoming.byDt.bySize.file.sp" + iSpec));
            this.biomassIn[iSpec] = timeSerieBySize.getValues();
            this.lengthIn[iSpec] = new float[timeSerieBySize.getNClass()];
            for (int iLength = 0; iLength < this.lengthIn[iSpec].length - 1; ++iLength) {
                this.lengthIn[iSpec][iLength] = (float)(0.5 * (double)(timeSerieBySize.getClass(iLength) + timeSerieBySize.getClass(iLength + 1)));
            }
            float lInf = this.getConfiguration().getFloat("species.linf.sp" + iSpec);
            this.lengthIn[iSpec][this.lengthIn[iSpec].length - 1] = (float)(0.5 * (double)(timeSerieBySize.getClass(this.lengthIn[iSpec].length - 1) + lInf));
            this.ageIn[iSpec] = new int[timeSerieBySize.getNClass()];
            for (int iLength = 0; iLength < this.ageIn[iSpec].length; ++iLength) {
                this.ageIn[iSpec][iLength] = this.getSpecies(iSpec).computeMeanAge(this.lengthIn[iSpec][iLength]);
            }
        }
    }

    @Override
    public void run() {
        int iTime = this.getSimulation().getIndexTimeSimu();
        for (int iSpec = 0; iSpec < this.getConfiguration().getNSpecies(); ++iSpec) {
            if (this.biomassIn[iSpec] == null) continue;
            Species species = this.getSpecies(iSpec);
            int nSchool = this.getConfiguration().getNSchool(iSpec);
            for (int iClass = 0; iClass < this.biomassIn[iSpec][iTime].length; ++iClass) {
                float meanWeigthIn = species.computeWeight(this.lengthIn[iSpec][iClass]);
                long abundanceIn = Math.round(this.biomassIn[iSpec][iTime][iClass] * 1000000.0 / (double)meanWeigthIn);
                if (abundanceIn > 0L && abundanceIn < (long)nSchool) {
                    this.getSchoolSet().add(new School(species, abundanceIn, this.lengthIn[iSpec][iClass], meanWeigthIn, this.ageIn[iSpec][iClass]));
                    continue;
                }
                if (abundanceIn < (long)nSchool) continue;
                double abdSchool = abundanceIn / (long)nSchool;
                for (int s = 0; s < nSchool; ++s) {
                    this.getSchoolSet().add(new School(species, abdSchool, this.lengthIn[iSpec][iClass], meanWeigthIn, this.ageIn[iSpec][iClass]));
                }
            }
        }
    }
}

