/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.output.AbundanceDistribOutput;
import fr.ird.osmose.output.AbundanceOutput;
import fr.ird.osmose.output.BiomassDietStageOutput;
import fr.ird.osmose.output.BiomassDistribOutput;
import fr.ird.osmose.output.BiomassOutput;
import fr.ird.osmose.output.DietDistribOutput;
import fr.ird.osmose.output.DietOutput;
import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.output.LTLOutput;
import fr.ird.osmose.output.MeanSizeCatchOutput;
import fr.ird.osmose.output.MeanSizeDistribOutput;
import fr.ird.osmose.output.MeanSizeOutput;
import fr.ird.osmose.output.MeanTrophicLevelCatchOutput;
import fr.ird.osmose.output.MeanTrophicLevelDistribOutput;
import fr.ird.osmose.output.MeanTrophicLevelOutput;
import fr.ird.osmose.output.MortalityOutput;
import fr.ird.osmose.output.MortalitySpeciesOutput;
import fr.ird.osmose.output.NDeadSchoolDistribOutput;
import fr.ird.osmose.output.NDeadSchoolOutput;
import fr.ird.osmose.output.NSchoolDistribOutput;
import fr.ird.osmose.output.NSchoolOutput;
import fr.ird.osmose.output.PredatorPressureDistribOutput;
import fr.ird.osmose.output.PredatorPressureOutput;
import fr.ird.osmose.output.SSBOutput;
import fr.ird.osmose.output.SchoolSetSnapshot;
import fr.ird.osmose.output.SpatialOutput;
import fr.ird.osmose.output.YieldDistribOutput;
import fr.ird.osmose.output.YieldNDistribOutput;
import fr.ird.osmose.output.YieldNOutput;
import fr.ird.osmose.output.YieldOutput;
import fr.ird.osmose.output.distribution.AgeDistribution;
import fr.ird.osmose.output.distribution.SizeDistribution;
import fr.ird.osmose.output.distribution.TLDistribution;
import fr.ird.osmose.util.SimulationLinker;
import fr.ird.osmose.util.io.IOTools;
import java.util.ArrayList;
import java.util.List;

public class OutputManager
extends SimulationLinker {
    private final List<IOutput> outputs = new ArrayList<IOutput>();
    private final SchoolSetSnapshot snapshot;
    private int restartFrequency;
    private boolean writeRestart;
    private int spinupRestart;

    public OutputManager(int rank) {
        super(rank);
        this.snapshot = new SchoolSetSnapshot(rank);
    }

    public void init() {
        int i;
        int rank = this.getRank();
        if (!this.getSimulation().isRestart()) {
            String pattern = this.getConfiguration().getString("output.file.prefix") + "*_Simu" + rank + "*";
            IOTools.deleteRecursively(this.getConfiguration().getOutputPathname(), pattern);
        }
        SizeDistribution sizeDistrib = new SizeDistribution();
        AgeDistribution ageDistrib = new AgeDistribution();
        if (this.getConfiguration().getBoolean("output.biomass.enabled")) {
            this.outputs.add(new BiomassOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.biomass.bysize.enabled")) {
            this.outputs.add(new BiomassDistribOutput(rank, sizeDistrib));
        }
        if (this.getConfiguration().getBoolean("output.biomass.byage.enabled")) {
            this.outputs.add(new BiomassDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.abundance.enabled")) {
            this.outputs.add(new AbundanceOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.abundance.bysize.enabled")) {
            this.outputs.add(new AbundanceDistribOutput(rank, sizeDistrib));
        }
        if (this.getConfiguration().getBoolean("output.abundance.byage.enabled")) {
            this.outputs.add(new AbundanceDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.mortality.enabled")) {
            this.outputs.add(new MortalityOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.mortality.perSpecies.byage.enabled")) {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.outputs.add(new MortalitySpeciesOutput(rank, this.getSpecies(i), ageDistrib));
            }
        }
        if (this.getConfiguration().getBoolean("output.mortality.perSpecies.bysize.enabled")) {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.outputs.add(new MortalitySpeciesOutput(rank, this.getSpecies(i), sizeDistrib));
            }
        }
        if (this.getConfiguration().getBoolean("output.yield.biomass.enabled")) {
            this.outputs.add(new YieldOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.yield.abundance.enabled")) {
            this.outputs.add(new YieldNOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.size.enabled")) {
            this.outputs.add(new MeanSizeOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.size.catch.enabled")) {
            this.outputs.add(new MeanSizeCatchOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.yieldN.bySize.enabled")) {
            this.outputs.add(new YieldNDistribOutput(rank, sizeDistrib));
        }
        if (this.getConfiguration().getBoolean("output.yield.bySize.enabled")) {
            this.outputs.add(new YieldDistribOutput(rank, sizeDistrib));
        }
        if (this.getConfiguration().getBoolean("output.meanSize.byAge.enabled")) {
            this.outputs.add(new MeanSizeDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.yieldN.byAge.enabled")) {
            this.outputs.add(new YieldNDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.yield.byAge.enabled")) {
            this.outputs.add(new YieldDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.tl.enabled")) {
            this.outputs.add(new MeanTrophicLevelOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.tl.catch.enabled")) {
            this.outputs.add(new MeanTrophicLevelCatchOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.biomass.bytl.enabled")) {
            this.outputs.add(new BiomassDistribOutput(rank, new TLDistribution()));
        }
        if (this.getConfiguration().getBoolean("output.meanTL.bySize.enabled")) {
            this.outputs.add(new MeanTrophicLevelDistribOutput(rank, sizeDistrib));
        }
        if (this.getConfiguration().getBoolean("output.meanTL.byAge.enabled")) {
            this.outputs.add(new MeanTrophicLevelDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.diet.composition.enabled")) {
            this.outputs.add(new DietOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.diet.composition.byage.enabled")) {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.outputs.add(new DietDistribOutput(rank, this.getSpecies(i), ageDistrib));
            }
        }
        if (this.getConfiguration().getBoolean("output.diet.composition.bysize.enabled")) {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.outputs.add(new DietDistribOutput(rank, this.getSpecies(i), sizeDistrib));
            }
        }
        if (this.getConfiguration().getBoolean("output.diet.pressure.enabled")) {
            this.outputs.add(new PredatorPressureOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.diet.pressure.enabled")) {
            this.outputs.add(new BiomassDietStageOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.diet.pressure.byage.enabled")) {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.outputs.add(new PredatorPressureDistribOutput(rank, this.getSpecies(i), ageDistrib));
            }
        }
        if (this.getConfiguration().getBoolean("output.diet.pressure.bysize.enabled")) {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.outputs.add(new PredatorPressureDistribOutput(rank, this.getSpecies(i), sizeDistrib));
            }
        }
        if (this.getConfiguration().getBoolean("output.spatial.enabled")) {
            this.outputs.add(new SpatialOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.spatial.ltl.enabled")) {
            this.outputs.add(new LTLOutput(rank));
        }
        boolean NO_WARNING = false;
        if (this.getConfiguration().getBoolean("output.ssb.enabled", NO_WARNING)) {
            this.outputs.add(new SSBOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.nschool.enabled", NO_WARNING)) {
            this.outputs.add(new NSchoolOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.nschool.byage.enabled", NO_WARNING)) {
            this.outputs.add(new NSchoolDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.nschool.bysize.enabled", NO_WARNING)) {
            this.outputs.add(new NSchoolDistribOutput(rank, sizeDistrib));
        }
        if (this.getConfiguration().getBoolean("output.ndeadschool.enabled", NO_WARNING)) {
            this.outputs.add(new NDeadSchoolOutput(rank));
        }
        if (this.getConfiguration().getBoolean("output.ndeadschool.byage.enabled", NO_WARNING)) {
            this.outputs.add(new NDeadSchoolDistribOutput(rank, ageDistrib));
        }
        if (this.getConfiguration().getBoolean("output.ndeadschool.bysize.enabled", NO_WARNING)) {
            this.outputs.add(new NDeadSchoolDistribOutput(rank, sizeDistrib));
        }
        for (IOutput indicator : this.outputs) {
            indicator.init();
            indicator.reset();
        }
        this.restartFrequency = Integer.MAX_VALUE;
        if (!this.getConfiguration().isNull("output.restart.recordfrequency.ndt")) {
            this.restartFrequency = this.getConfiguration().getInt("output.restart.recordfrequency.ndt");
        }
        this.writeRestart = true;
        if (!this.getConfiguration().isNull("output.restart.enabled")) {
            this.writeRestart = this.getConfiguration().getBoolean("output.restart.enabled");
        } else {
            this.warning("Could not find parameter 'output.restart.enabled'. Osmose assumes it is true and a NetCDF restart file will be created at the end of the simulation (or more, depending on parameters 'simulation.restart.recordfrequency.ndt' and 'simulation.restart.spinup').");
        }
        this.spinupRestart = 0;
        if (!this.getConfiguration().isNull("output.restart.spinup")) {
            this.spinupRestart = this.getConfiguration().getInt("output.restart.spinup") - 1;
        }
    }

    public void close() {
        for (IOutput indicator : this.outputs) {
            indicator.close();
        }
    }

    public void initStep() {
        if (this.getSimulation().getYear() >= this.getConfiguration().getInt("output.start.year")) {
            for (IOutput indicator : this.outputs) {
                indicator.initStep();
            }
        }
    }

    public void update(int iStepSimu) {
        if (this.getSimulation().getYear() >= this.getConfiguration().getInt("output.start.year")) {
            for (IOutput indicator : this.outputs) {
                indicator.update();
                if (!indicator.isTimeToWrite(iStepSimu)) continue;
                float time = (float)(iStepSimu + 1) / (float)this.getConfiguration().getNStepYear();
                indicator.write(time);
                indicator.reset();
            }
        }
    }

    public void writeRestart(int iStepSimu) {
        boolean isTimeToWrite = this.writeRestart;
        isTimeToWrite &= this.getSimulation().getYear() >= this.spinupRestart;
        isTimeToWrite &= (iStepSimu + 1) % this.restartFrequency == 0;
        if (isTimeToWrite |= iStepSimu >= this.getConfiguration().getNYear() * this.getConfiguration().getNStepYear() - 1) {
            this.snapshot.makeSnapshot(iStepSimu);
        }
    }
}

