/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.util.SimulationLinker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MortalityOutput
extends SimulationLinker
implements IOutput {
    private FileOutputStream[] fos;
    private PrintWriter[] prw;
    private int recordFrequency;
    private final int STAGES = 3;
    private final int EGG = 0;
    private final int PRE_RECRUIT = 1;
    private final int RECRUIT = 2;
    private double[][][] mortalityRates;
    private double[][] abundanceStage;
    private int[] recruitmentAge;
    private final String separator = this.getConfiguration().getOutputSeparator();

    public MortalityOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
        this.abundanceStage = new double[this.getNSpecies()][3];
        for (School school : this.getSchoolSet()) {
            int iStage = school.getAgeDt() == 0 ? 0 : (school.getAgeDt() < this.recruitmentAge[school.getSpeciesIndex()] ? 1 : 2);
            double[] dArray = this.abundanceStage[school.getSpeciesIndex()];
            int n = iStage;
            dArray[n] = dArray[n] + school.getAbundance();
        }
    }

    @Override
    public void reset() {
        this.mortalityRates = new double[this.getNSpecies()][MortalityCause.values().length][3];
    }

    @Override
    public void update() {
        int iStage;
        int nCause = MortalityCause.values().length;
        double[][][] nDead = new double[this.getNSpecies()][nCause][3];
        for (School school : this.getSchoolSet()) {
            iStage = school.getAgeDt() == 0 ? 0 : (school.getAgeDt() < this.recruitmentAge[school.getSpeciesIndex()] ? 1 : 2);
            int iSpecies = school.getSpeciesIndex();
            for (MortalityCause cause : MortalityCause.values()) {
                double[] dArray = nDead[iSpecies][cause.index];
                int n = iStage;
                dArray[n] = dArray[n] + school.getNdead(cause);
            }
        }
        for (int iSpecies = 0; iSpecies < this.getNSpecies(); ++iSpecies) {
            for (iStage = 0; iStage < 3; ++iStage) {
                if (!(this.abundanceStage[iSpecies][iStage] > 0.0)) continue;
                double nDeadTot = 0.0;
                for (int iDeath = 0; iDeath < nCause; ++iDeath) {
                    nDeadTot += nDead[iSpecies][iDeath][iStage];
                }
                double Ftot = Math.log(this.abundanceStage[iSpecies][iStage] / (this.abundanceStage[iSpecies][iStage] - nDeadTot));
                for (int iDeath = 0; iDeath < nCause; ++iDeath) {
                    double[] dArray = this.mortalityRates[iSpecies][iDeath];
                    int n = iStage;
                    dArray[n] = dArray[n] + Ftot * nDead[iSpecies][iDeath][iStage] / ((1.0 - Math.exp(-Ftot)) * this.abundanceStage[iSpecies][iStage]);
                }
            }
        }
    }

    @Override
    public void write(float time) {
        for (int iSpecies = 0; iSpecies < this.getNSpecies(); ++iSpecies) {
            this.prw[iSpecies].print(time);
            this.prw[iSpecies].print(this.separator);
            for (int iDeath = 0; iDeath < MortalityCause.values().length; ++iDeath) {
                for (int iStage = 0; iStage < 3; ++iStage) {
                    if (iDeath == MortalityCause.ADDITIONAL.index && iStage == 0) {
                        this.prw[iSpecies].print(this.mortalityRates[iSpecies][iDeath][iStage] / (double)this.recordFrequency);
                    } else {
                        this.prw[iSpecies].print(this.mortalityRates[iSpecies][iDeath][iStage]);
                    }
                    this.prw[iSpecies].print(this.separator);
                }
            }
            this.prw[iSpecies].println();
        }
    }

    @Override
    public void init() {
        this.recordFrequency = this.getConfiguration().getInt("output.recordfrequency.ndt");
        this.fos = new FileOutputStream[this.getNSpecies()];
        this.prw = new PrintWriter[this.getNSpecies()];
        this.recruitmentAge = new int[this.getNSpecies()];
        for (int iSpecies = 0; iSpecies < this.getNSpecies(); ++iSpecies) {
            File path = new File(this.getConfiguration().getOutputPathname());
            StringBuilder filename = new StringBuilder("Mortality");
            filename.append(File.separatorChar);
            filename.append(this.getConfiguration().getString("output.file.prefix"));
            filename.append("_mortalityRate-");
            filename.append(this.getSimulation().getSpecies(iSpecies).getName());
            filename.append("_Simu");
            filename.append(this.getRank());
            filename.append(".csv");
            File file = new File(path, filename.toString());
            boolean fileExists = file.exists();
            file.getParentFile().mkdirs();
            try {
                this.fos[iSpecies] = new FileOutputStream(file, true);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(MortalityOutput.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.prw[iSpecies] = new PrintWriter(this.fos[iSpecies], true);
            if (!fileExists) {
                int i;
                this.prw[iSpecies].println(this.quote("Predation (Mpred), Starvation (Mstarv), Other Natural mortality (Mnat), Fishing (F) & Out-of-domain (Zout) mortality rates per time step of saving, except for Mnat Eggs that is expressed in osmose time step. Z is the total mortality for migratory fish outside the simulation grid. To get annual mortality rates, sum the mortality rates within one year."));
                this.prw[iSpecies].print(this.quote("Time"));
                for (i = 0; i < 3; ++i) {
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print(this.quote("Mpred"));
                }
                for (i = 0; i < 3; ++i) {
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print(this.quote("Mstarv"));
                }
                for (i = 0; i < 3; ++i) {
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print(this.quote("Mnat"));
                }
                for (i = 0; i < 3; ++i) {
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print(this.quote("F"));
                }
                for (i = 0; i < 3; ++i) {
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print(this.quote("Zout"));
                }
                this.prw[iSpecies].println();
                for (MortalityCause cause : MortalityCause.values()) {
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print("Eggs");
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print("Pre-recruits");
                    this.prw[iSpecies].print(this.separator);
                    this.prw[iSpecies].print("Recruits");
                }
                this.prw[iSpecies].println();
            }
            if (!this.getConfiguration().isNull("mortality.fishing.recruitment.age.sp" + iSpecies)) {
                float age = this.getConfiguration().getFloat("mortality.fishing.recruitment.age.sp" + iSpecies);
                this.recruitmentAge[iSpecies] = Math.round(age * (float)this.getConfiguration().getNStepYear());
                continue;
            }
            if (!this.getConfiguration().isNull("mortality.fishing.recruitment.size.sp" + iSpecies)) {
                float recruitmentSize = this.getConfiguration().getFloat("mortality.fishing.recruitment.size.sp" + iSpecies);
                this.recruitmentAge[iSpecies] = this.getSpecies(iSpecies).computeMeanAge(recruitmentSize);
                continue;
            }
            this.getSimulation().warning("Could not find parameters mortality.fishing.recruitment.age/size.sp{0}. Osmose assumes it is one year.", new Object[]{iSpecies});
            this.recruitmentAge[iSpecies] = this.getConfiguration().getNStepYear();
        }
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }

    @Override
    public void close() {
        for (int iSpecies = 0; iSpecies < this.getNSpecies(); ++iSpecies) {
            if (null != this.prw) {
                this.prw[iSpecies].close();
            }
            if (null == this.fos) continue;
            try {
                this.fos[iSpecies].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isTimeToWrite(int iStepSimu) {
        return (iStepSimu + 1) % this.recordFrequency == 0;
    }
}

