/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.Cell;
import fr.ird.osmose.Prey;
import fr.ird.osmose.School;
import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.output.SpatialOutput;
import fr.ird.osmose.util.SimulationLinker;
import fr.ird.osmose.util.io.IOTools;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class LTLOutput
extends SimulationLinker
implements IOutput {
    private final float FILLVALUE = -99.0f;
    private NetcdfFileWriteable nc;
    private double[][][] ltlbiomass0;
    private double[][][] ltlbiomass1;

    public LTLOutput(int rank) {
        super(rank);
        this.getSimulation().requestPreyRecord();
    }

    @Override
    public void init() {
        String filename = this.getFilename();
        IOTools.makeDirectories(filename);
        this.createNCFile(filename);
    }

    @Override
    public void close() {
        try {
            this.nc.close();
            String strFilePart = this.nc.getLocation();
            String strFileBase = strFilePart.substring(0, strFilePart.indexOf(".part"));
            File filePart = new File(strFilePart);
            File fileBase = new File(strFileBase);
            filePart.renameTo(fileBase);
        }
        catch (IOException ex) {
            this.warning("Problem closing the NetCDF output file ==> {0}", ex.toString());
        }
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        int nx = this.getGrid().get_nx();
        int ny = this.getGrid().get_ny();
        this.ltlbiomass0 = new double[this.getConfiguration().getNPlankton()][ny][nx];
        this.ltlbiomass1 = new double[this.getConfiguration().getNPlankton()][ny][nx];
    }

    @Override
    public void update() {
        int nspec = this.getNSpecies();
        for (Cell cell : this.getGrid().getCells()) {
            if (cell.isLand()) continue;
            List<School> schools = this.getSchoolSet().getSchools(cell);
            double[] preyedLTL = new double[this.getConfiguration().getNPlankton()];
            for (School school : schools) {
                for (Prey prey : school.getPreys()) {
                    int iltl = prey.getSpeciesIndex() - nspec;
                    if (iltl < 0) continue;
                    int n = iltl;
                    preyedLTL[n] = preyedLTL[n] + prey.getBiomass();
                }
            }
            int i = cell.get_igrid();
            int j = cell.get_jgrid();
            for (int iltl = 0; iltl < this.getConfiguration().getNPlankton(); ++iltl) {
                this.ltlbiomass0[iltl][j][i] = this.getSimulation().getPlankton(iltl).getBiomass(cell);
                this.ltlbiomass1[iltl][j][i] = this.ltlbiomass0[iltl][j][i] - preyedLTL[iltl];
            }
        }
    }

    @Override
    public void write(float time) {
        for (Cell cell : this.getGrid().getCells()) {
            int i = cell.get_igrid();
            int j = cell.get_jgrid();
            if (!cell.isLand()) continue;
            for (int iltl = 0; iltl < this.getConfiguration().getNPlankton(); ++iltl) {
                this.ltlbiomass0[iltl][j][i] = -99.0;
                this.ltlbiomass1[iltl][j][i] = -99.0;
            }
        }
        ArrayFloat.D4 arrLTL0 = new ArrayFloat.D4(1, this.getConfiguration().getNPlankton(), this.getGrid().get_ny(), this.getGrid().get_nx());
        ArrayFloat.D4 arrLTL1 = new ArrayFloat.D4(1, this.getConfiguration().getNPlankton(), this.getGrid().get_ny(), this.getGrid().get_nx());
        int nl = this.getGrid().get_ny() - 1;
        for (int kltl = 0; kltl < this.getConfiguration().getNPlankton(); ++kltl) {
            for (int j = 0; j < this.getGrid().get_ny(); ++j) {
                for (int i = 0; i < this.getGrid().get_nx(); ++i) {
                    arrLTL0.set(0, kltl, j, i, (float)this.ltlbiomass0[kltl][j][i]);
                    arrLTL1.set(0, kltl, j, i, (float)this.ltlbiomass1[kltl][j][i]);
                }
            }
        }
        ArrayFloat.D1 arrTime = new ArrayFloat.D1(1);
        arrTime.set(0, time * 360.0f);
        int index = this.nc.getUnlimitedDimension().getLength();
        try {
            this.nc.write("time", new int[]{index}, arrTime);
            this.nc.write("ltl_biomass", new int[]{index, 0, 0, 0}, arrLTL0);
            this.nc.write("ltl_biomass_pred", new int[]{index, 0, 0, 0}, arrLTL1);
        }
        catch (IOException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void createNCFile(String ncfile) {
        try {
            this.nc = NetcdfFileWriteable.createNew("");
            this.nc.setLocation(ncfile);
        }
        catch (IOException ex) {
            Logger.getLogger(LTLOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        Dimension ltlDim = this.nc.addDimension("ltl", this.getConfiguration().getNPlankton());
        Dimension nxDim = this.nc.addDimension("nx", this.getGrid().get_nx());
        Dimension nyDim = this.nc.addDimension("ny", this.getGrid().get_ny());
        Dimension timeDim = this.nc.addUnlimitedDimension("time");
        this.nc.addVariable("time", DataType.FLOAT, new Dimension[]{timeDim});
        this.nc.addVariableAttribute("time", "units", "days since 1-1-1 0:0:0");
        this.nc.addVariableAttribute("time", "calendar", "360_day");
        this.nc.addVariableAttribute("time", "description", "time ellapsed, in days, since the beginning of the simulation");
        this.nc.addVariable("ltl_biomass", DataType.FLOAT, new Dimension[]{timeDim, ltlDim, nyDim, nxDim});
        this.nc.addVariableAttribute("ltl_biomass", "units", "tons per cell");
        this.nc.addVariableAttribute("ltl_biomass", "description", "plankton biomass in osmose cell, in tons integrated on water column, per group and per cell");
        this.nc.addVariableAttribute("ltl_biomass", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("ltl_biomass_pred", DataType.FLOAT, new Dimension[]{timeDim, ltlDim, nyDim, nxDim});
        this.nc.addVariableAttribute("ltl_biomass_pred", "units", "tons per cell");
        this.nc.addVariableAttribute("ltl_biomass_pred", "description", "plankton biomass after predation process in osmose cell, in tons integrated on water column, per group and per cell");
        this.nc.addVariableAttribute("ltl_biomass_pred", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("latitude", DataType.FLOAT, new Dimension[]{nyDim, nxDim});
        this.nc.addVariableAttribute("latitude", "units", "degree");
        this.nc.addVariableAttribute("latitude", "description", "latitude of the center of the cell");
        this.nc.addVariable("longitude", DataType.FLOAT, new Dimension[]{nyDim, nxDim});
        this.nc.addVariableAttribute("longitude", "units", "degree");
        this.nc.addVariableAttribute("longitude", "description", "longitude of the center of the cell");
        StringBuilder str = new StringBuilder();
        for (int kltl = 0; kltl < this.getConfiguration().getNPlankton(); ++kltl) {
            str.append(kltl);
            str.append("=");
            str.append(this.getSimulation().getPlankton(kltl));
            str.append(" ");
        }
        this.nc.addGlobalAttribute("dimension_ltl", str.toString());
        try {
            this.nc.create();
            ArrayFloat.D2 arrLon = new ArrayFloat.D2(this.getGrid().get_ny(), this.getGrid().get_nx());
            ArrayFloat.D2 arrLat = new ArrayFloat.D2(this.getGrid().get_ny(), this.getGrid().get_nx());
            for (Cell cell : this.getGrid().getCells()) {
                arrLon.set(cell.get_jgrid(), cell.get_igrid(), cell.getLon());
                arrLat.set(cell.get_jgrid(), cell.get_igrid(), cell.getLat());
            }
            this.nc.write("longitude", arrLon);
            this.nc.write("latitude", arrLat);
        }
        catch (IOException ex) {
            Logger.getLogger(LTLOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(LTLOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getFilename() {
        File path = new File(this.getConfiguration().getOutputPathname());
        StringBuilder filename = new StringBuilder(path.getAbsolutePath());
        filename.append(File.separatorChar);
        filename.append("planktonBiomass");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_ltlbiomass_integrated_");
        filename.append("Simu");
        filename.append(this.getRank());
        filename.append(".nc.part");
        return filename.toString();
    }

    @Override
    public boolean isTimeToWrite(int iStepSimu) {
        return true;
    }
}

