/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.grid;

import fr.ird.osmose.Cell;
import fr.ird.osmose.grid.AbstractGrid;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.nc2.NetcdfFile;

public class BFMGrid
extends AbstractGrid {
    private String gridFile;
    private String strLon;
    private String strLat;
    private String strMask;
    private int stride;

    @Override
    public void readParameters() {
        this.gridFile = this.getConfiguration().getFile("grid.netcdf.file");
        this.strLat = this.getConfiguration().getString("grid.var.lat");
        this.strLon = this.getConfiguration().getString("grid.var.lon");
        this.strMask = this.getConfiguration().getString("grid.var.mask");
        this.stride = this.getConfiguration().getInt("grid.stride");
    }

    private NetcdfFile openNetcdfFile(String gridFile) {
        try {
            return NetcdfFile.open(gridFile, null);
        }
        catch (IOException ex) {
            this.error("Failed to open NetCDF grid file " + gridFile, ex);
            return null;
        }
    }

    private float[][] readBFMVariable(NetcdfFile nc, String varname) {
        try {
            return (float[][])nc.findVariable(varname).read().copyToNDJavaArray();
        }
        catch (IOException ex) {
            this.error("Error while reading variable " + varname + " in NetCDF grid file " + nc.getLocation(), ex);
            return null;
        }
    }

    private float[][] bfm2osmose(float[][] var, int stride) {
        int jmstr = var.length / stride;
        int imstr = var[0].length / stride;
        float[][] striddenVar = new float[jmstr][imstr];
        for (int i = 0; i < imstr; ++i) {
            for (int j = 0; j < jmstr; ++j) {
                striddenVar[j][i] = 0.5f * (var[(j + 1) * stride - 1][i * stride] + var[j * stride][i * stride]);
            }
        }
        return striddenVar;
    }

    @Override
    Cell[][] makeGrid() {
        NetcdfFile ncGrid = this.openNetcdfFile(this.gridFile);
        float[][] lon = this.bfm2osmose(this.readBFMVariable(ncGrid, this.strLon), this.stride);
        float[][] lat = this.bfm2osmose(this.readBFMVariable(ncGrid, this.strLat), this.stride);
        float[][] mask = null;
        try {
            mask = (float[][])ncGrid.findVariable(this.strMask).read().copyToNDJavaArray();
        }
        catch (IOException ex) {
            Logger.getLogger(BFMGrid.class.getName()).log(Level.SEVERE, null, ex);
        }
        int jmstr = lon.length;
        int imstr = lon[0].length;
        Cell[][] grid = new Cell[jmstr][imstr];
        for (int i = 0; i < imstr; ++i) {
            for (int j = 0; j < jmstr; ++j) {
                float fmask = 0.0f;
                for (int ii = 0; ii < this.stride; ++ii) {
                    for (int jj = 0; jj < this.stride; ++jj) {
                        fmask += mask[j * this.stride + jj][i * this.stride + ii];
                    }
                }
                boolean land = (double)(fmask /= (float)(this.stride * this.stride)) <= 0.5;
                grid[j][i] = new Cell(j * imstr + i, i, j, lat[j][i], lon[j][i], land);
            }
        }
        return grid;
    }
}

