% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectors.R
\name{license_text}
\alias{license_text}
\title{Retrieve license text}
\usage{
license_text(license_metadata, ...)
}
\arguments{
\item{license_metadata}{metadata returned from \code{\link{license_by_id}},
\code{\link{license_by_keyword}} or \code{\link{license_list}} which covers
the licenses you want the text of.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
a data.frame of 3 columns; "license" containing the license IDs,
"content" containing the actual text, and "retrieved_from" indicating the
URL the content was returned from. In the event that the plaintext of a license
is not available (because a URL for it was not in the metadata), \code{content}
and \code{retrieved_from} will be NAs.
}
\description{
\code{license_text} grabs the actual plaintext of a set of
licenses within the provided metadata, wherever possible.
}
\examples{
gpl_2_text <- license_text(license_by_id("GPL-2.0"))

}

