% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orf_user.R
\name{print.orf}
\alias{print.orf}
\title{Print of the Ordered Forest}
\usage{
\method{print}{orf}(x, ...)
}
\arguments{
\item{x}{estimated Ordered Forest object of class \code{orf}}

\item{...}{further arguments (currently ignored)}
}
\description{
print of an estimated Ordered Forest object of class \code{orf}
}
\details{
\code{print.orf} provides a first glimpse of the Ordered Forest estimation,
printed directly to the \code{R} console. The printed information contains
the main inputs of the \code{orf} function.
}
\examples{
# Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates
Y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

# estimate Ordered Forest
orf_fit <- orf(X, Y)

# print output of the orf estimation
print(orf_fit)

}
\author{
Gabriel Okasa
}
