% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.ordinalbayes}
\alias{summary.ordinalbayes}
\title{Summarize an Ordinal Bayes Object.}
\usage{
\method{summary}{ordinalbayes}(object, epsilon = 0.1, ...)
}
\arguments{
\item{object}{A fitted \code{ordinalbayes} object.}

\item{epsilon}{a small positive value that is close to 0 for testing an interval null hypothesis for the beta parameters.}

\item{...}{other arguments.}
}
\value{
\item{alphamatrix}{The MCMC output for the threshold parameters.}

\item{betamatrix}{The MCMC output for the penalized parameters.}

\item{zetamatrix}{The MCMC output for the unpenalized parameters (if included).}

\item{gammamatrix}{The MCMC output for the variable inclusion parameters (not available for lasso).}

\item{gammamean}{The posterior mean of the variable inclusion indicators (not available for lasso)for the variable inclusion indicators (not available for lasso).}

\item{gamma.BayesFactor}{Bayes factor for the variable inclusion indicators (not available for lasso).}

\item{Beta.BayesFactor}{Bayes factor for the penalized parameters where the interval null is tested using epsilon.}

\item{lambdamatrix}{The MCMC output for the penalty parameter (not available for normalss).}
}
\description{
Summarize an Ordinal Bayes Object.
}
\examples{
\donttest{
data("cesc")
fit<-ordinalbayes(Stage~1, data=cesc, x=cesc[,5:45],
         model="regressvi", gamma.ind="fixed", pi.fixed=0.99,
         adaptSteps=1000, burnInSteps=1000, nChains=2,
         numSavedSteps=2000, thinSteps=2, seed=26)
summary.fit<-summary(fit)
names(summary.fit)
names(which(summary.fit$Beta.BayesFactor>5))
names(which(summary.fit$gamma.BayesFactor>5))
}
}
\seealso{
\code{\link{ordinalbayes}}, \code{\link{print.ordinalbayes}}, \code{\link{coef.ordinalbayes}}, \code{\link{predict.ordinalbayes}}
}
