% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalbayes.R
\name{ordinalbayes}
\alias{ordinalbayes}
\title{Ordinal Bayesian Regression Models for High-Dimensional Data}
\usage{
ordinalbayes(
  formula,
  data,
  x = NULL,
  subset,
  center = TRUE,
  scale = TRUE,
  a = 0.1,
  b = 0.1,
  model = "regressvi",
  gamma.ind = "fixed",
  pi.fixed = 0.05,
  c.gamma = NULL,
  d.gamma = NULL,
  alpha.var = 10,
  sigma2.0 = NULL,
  sigma2.1 = NULL,
  coerce.var = 10,
  lambda0 = NULL,
  nChains = 3,
  adaptSteps = 5000,
  burnInSteps = 5000,
  numSavedSteps = 9999,
  thinSteps = 3,
  parallel = TRUE,
  seed = NULL,
  quiet = FALSE
)
}
\arguments{
\item{formula}{an object of class "\code{formula}" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The left side of the formula is the ordinal outcome while the variables on the right side of the formula are the covariates that are not included in the penalization process. Note that if all variables in the model are to be penalized, an intercept only model formula should be specified.}

\item{data}{an optional data.frame, list or environment (or object coercible by \code{as.data.frame} to a data frame) containing the variables in the model.}

\item{x}{an optional matrix of predictors that are to be penalized in the model fitting process.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{center}{logical, if TRUE the penalized predictors are centered.}

\item{scale}{logical, if TRUE the penalized predictors are scaled.}

\item{a}{hyperprior for the penalty parameter lambda which is Gamma with parameters \code{a} and \code{b}.}

\item{b}{hyperprior for the penalty parameter lambda which is Gamma with parameters \code{a} and \code{b}.}

\item{model}{Specify which penalized ordinal model to fit  as "regressvi", "lasso", "dess", or "normalss".}

\item{gamma.ind}{indicates whether prior for the variable inclusion indicators is "fixed" or "random" (for models "regressvi", "dess", or "normalss").}

\item{pi.fixed}{constant prior for the variable inclusion indicators is when \code{gamma.ind="fixed"}.}

\item{c.gamma}{hyperprior for the variable inclusion indicators is when \code{gamma.ind="random"}.}

\item{d.gamma}{hyperprior for the variable inclusion indicators is when \code{gamma.ind="random"}.}

\item{alpha.var}{variance for alpha_k thresholds in the MCMC chain (default 10).}

\item{sigma2.0}{variance for the spike when \code{model="normalss"} (set to some small positive value).}

\item{sigma2.1}{variance for the slab when \code{model="normalss"} (set to some large positive value).}

\item{coerce.var}{variance associated with any unpenalized predictors in the MCMC chain (default 10).}

\item{lambda0}{parameter value for the spike when \code{model="dess"}.}

\item{nChains}{number of parallel chains to run (default 3)}

\item{adaptSteps}{number of iterations for adaptation (default 5,000).}

\item{burnInSteps}{number of iterations of the Markov chain to run (default 5,000).}

\item{numSavedSteps}{number of saved steps per chain (default 9,999).}

\item{thinSteps}{thinning interval for monitors (default 3).}

\item{parallel}{logical, run the MCMC on multiple processors (default TRUE).}

\item{seed}{integer, seed to ensure reproducibility.}

\item{quiet}{logical, when TRUE, suppress output of JAGS (or rjags) when updating models}
}
\value{
\code{results} An object of class runjags

\code{call} Model call

\code{model} Name of the ordinal model that was fit

\code{a} Value the user specified for \code{a}

\code{b} Value the user specified for \code{b}

\code{featureNames} Names of the penalized predictors

\code{center} Value the user specified for \code{center}

\code{scale} Value the user specified for \code{scale}

\code{y} Observed ordinal response

\code{x} Matrix of penalized predictors used in model fitting

\code{w} Matrix of unpenalized predictors used in model fitting

\code{gamma.ind} Value the user specified for \code{gamma.ind}

\code{pi.fixed} Value the user specified for \code{pi.fixed} if \code{gamma.ind="fixed"}

\code{c.gamma} Value the user specified for \code{c.gamma} if \code{gamma.ind="random"}

\code{d.gamma} Value the user specified for \code{d.gamma} if \code{gamma.ind="random"}

\code{sigma2.0} Value the user specified for \code{sigma2.0} if \code{model="normalss"}

\code{sigma2.1} Value the user specified for \code{sigma2.1} if \code{model="normalss"}

\code{lambda0} value the user specified for \code{lambda0} if \code{model="dess"}
}
\description{
Ordinal Bayesian Regression Models for High-Dimensional Data
}
\examples{
\donttest{
# The number of adaptSteps, burnInSteps, and numSavedSteps was reduced for package testing
library(DESeq2)
data(reducedSet)
fit<-ordinalbayes(Stage~1, data=colData(reducedSet),x=t(assay(reducedSet)),
         model="regressvi", gamma.ind="fixed", pi.fixed=0.99,
         adaptSteps=1000, burnInSteps=1000, nChains=2,
         numSavedSteps=2000, thinSteps=2, seed=26)
}
}
\seealso{
\code{\link{print.ordinalbayes}}, \code{\link{summary.ordinalbayes}}, \code{\link{coef.ordinalbayes}}
}
\keyword{models}
\keyword{regression}
