% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ordinalNet.R
\name{predict.ordinalNetFit}
\alias{predict.ordinalNetFit}
\title{Predict method for an "ordinalNetFit" object}
\usage{
\method{predict}{ordinalNetFit}(object, newx = NULL, whichLambda = NULL,
  criteria = c("aic", "bic"), type = c("class", "prob"), ...)
}
\arguments{
\item{object}{An "ordinalNetFit" S3 object.}

\item{newx}{Optional covariate matrix. If the model was fit with a centered
and scaled matrix, then \code{newx} should be centered and scaled as well.}

\item{whichLambda}{Optional index number of the desired \code{lambda} within
the sequence of \code{lambda} values in the solution path.}

\item{criteria}{Selects the best \code{lambda} value by AIC or BIC. Only used
if \code{whichLambda=NULL}.}

\item{type}{Specifies whether to return a vector of predicted class numbers
or a matrix of fitted class probabilities.}

\item{...}{Not used. Additional predict arguments.}
}
\value{
A vector of predicted class numbers or a matrix of fitted class probabilities,
depending on \code{type}.
#'
}
\description{
Obtains predicted class numbers or fitted class probabilities for either
the model matrix used to fit the model or a new model matrix.
}
\examples{
set.seed(10)
x <- matrix(rnorm(50*5), ncol=5)
beta <- c(1, 0, 0, 0, 0)
intercepts <- c(-1, 1)
xb <- x \%*\% beta
eta <- cbind(xb+intercepts[1], xb+intercepts[2])
probMatCumul <- 1 / (1 + exp(-eta))
probMat <- cbind(probMatCumul, 1) - cbind(0, probMatCumul)
y <- apply(probMat, 1, function(p) sample(1:3, size=1, prob=p))
y <- as.factor(y)
fit <- ordinalNet(x, y)
predict(fit, type="class")
predict(fit, type="prob")
}

