% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{orderly_migrate}
\alias{orderly_migrate}
\title{Migrate an orderly archive}
\usage{
orderly_migrate(root = NULL, locate = TRUE, to = NULL,
  dry_run = FALSE, skip_failed = FALSE, clean = FALSE)
}
\arguments{
\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{to}{The version to migrate to.  The default is the current
archive version; this is almost always what is wanted.}

\item{dry_run}{Logical, indicating if we should try running the
migration but not actually applying it.  This is intended
primarily for developing new migrations and will probably not
work if you are multiple archive versions behind.}

\item{skip_failed}{Logical, where \code{TRUE} we will skip over
entries that failed to be migrated.  This is expected to be
useful on local archives only because it violates the
append-only nature of orderly.  However, if a local archive
contains unusual copies of orderly archives that can't be
migrated this might come in helpful.}

\item{clean}{Logical, where \code{TRUE} (and where the migration
was successful and \code{dry_run} is \code{FALSE}) orderly will
clean up all migration backup files.  Use this periodically to
clean up the archive.}
}
\value{
No return value, this function is called only for its side effects
}
\description{
Migrate an orderly archive.  This is needed periodically when the
orderly archive version changes.  If you get a message like
\code{orderly archive needs migrating from a.b.c => x.y.z} then
you need to run this function.  The archive version is at most
equal to the package version.
}
\details{
Sometimes we add change information saved out in the orderly run.
This requires patching previously run versions of the orderly
metadata and that's not something we want to do lightly.  This
function uses a relatively safe, and reversible, way of migrating
metadata.  We modify the \code{orderly_run.rds} files, but will
create versioned backups as files are changed.
}
\examples{
# Without an orderly repository created by a previous version of
# orderly, this function does nothing interesting:
path <- orderly::orderly_example("minimal")
orderly::orderly_migrate(path)
}
