% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ism.R
\name{summary.ism}
\alias{summary.ism}
\alias{summary.InfinitySparseMatrix}
\alias{summary.BlockedInfinitySparseMatrix}
\alias{summary.DenseMatrix}
\title{Summarize a distance matrix}
\usage{
\method{summary}{InfinitySparseMatrix}(object, ...,
  distanceSummary = TRUE)

\method{summary}{BlockedInfinitySparseMatrix}(object, ...,
  distanceSummary = TRUE, printAllBlocks = FALSE,
  blockStructure = TRUE)

\method{summary}{DenseMatrix}(object, ..., distanceSummary = TRUE)
}
\arguments{
\item{object}{A \code{InfinitySparseMatrix},
\code{BlockedInfinitySparseMatrix} or \code{DenseMatrix}.}

\item{...}{Ignored.}

\item{distanceSummary}{Default \code{TRUE}. Should a summary of
minimum distance per treatment member be calculated? May be slow
on larger data sets.}

\item{printAllBlocks}{If \code{object} is a
\code{BlockedInfinitySparseMatrix}, should summaries of all
blocks be printed alongside the overall summary? Default
\code{FALSE}.}

\item{blockStructure}{If \code{object} is a
\code{BlockedInfinitySparseMatrix} and \code{printAllBlocks} is
false, print a quick summary of each individual block. Default
\code{TRUE}. If the number of blocks is high, consider
suppressing this.}
}
\value{
A named \code{list}. The summary for an
  \code{InfinitySparseMatrix} or \code{DenseMatrix} contains the
  following:

  \itemize{

   \item{\code{total}: }{Contains the total number of treatment
    and control members, as well as eligible and ineligible
    matches.}

   \item{\code{matchable}: }{The names of all treatment and
    control members with at least one eligible match.}

   \item{\code{unmatchable}: }{The names of all treatment and
    control members with no eligible matches.}

   \item{\code{distances}: }{The summary of minimum matchable
    distances, if \code{distanceSummary} is \code{TRUE}.}

  }

  For \code{BlockedInfinitySparseMatrix}, the named \code{list}
  instead of contains one entry per block, named after each block
  (i.e. the value of the blocking variable) as well as a block
  named 'overall' which contains the summary ignoring blocks. Each
  of these entries contains a \code{list} with entries 'total',
  'matchable', 'unmatchable' and 'distances', as described above.
}
\description{
Given a distance matrix, return information above it, including
dimension, sparsity information, unmatchable members, summary of
finite distances, and, in the case of
\code{BlockedInfinitySparseMatrix}, block structure.
}
\details{
The output consists of several pieces.

\itemize{
 \item{Membership: }{Indicates the dimension of the distance.}

\item{Total (in)eligible potential matches: }{A measure of the
  sparsity of the distance. Eligible matches have a finite
  distance between treatment and control members; they could be
  matched. Ineligible matches have \code{Inf} distance and can not
  be matched. A higher number of ineligible matches can speed up
  matching, but runs the risk of less optimal overall matching
  results.}

\item{Unmatchable treatment/control members: }{If any
  observations have no eligible matches (e.g. their distance to
  every potential match is \code{Inf}) they are listed here. See
  Value below for details of how to access lists of matchable and
  unmatchable treatment and control members.}

\item{Summary of minimum matchable distance per treatment member:
  }{To assist with choosing a caliper, this is a numeric summary
  of the smallest distance per matchable treatment member. If you
  provide a caliper that is less than the maximum value, at least
  one treatment member will become unmatchable.}

\item{Block structure: }{For \code{BlockedInfinitySparseMatrix},
  a quick summary of the structure of each individual block. (The
  above will all be across all blocks.) This may indicate which
  blocks, if any, are problematic.}
}
}
