% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optmatch.R
\name{optmatch_same_distance}
\alias{optmatch_same_distance}
\title{Checks if two distances are equivalent. \code{x} and \code{y} can be
distances (\code{InfinitySparseMatrix}, \code{BlockedInfinitySparseMatrix},
or \code{DenseMatrix}), or they can be \code{optmatch} objects.}
\usage{
optmatch_same_distance(x, y)
}
\arguments{
\item{x}{A distances (\code{InfinitySparseMatrix},
\code{BlockedInfinitySparseMatrix}, or \code{DenseMatrix}), or
\code{optmatch} object.}

\item{y}{A distances (\code{InfinitySparseMatrix},
\code{BlockedInfinitySparseMatrix}, or \code{DenseMatrix}), or
\code{optmatch} object.}
}
\value{
Boolean whether the two distance specifications are identical.
}
\description{
To save space, \code{optmatch} objects merely store a hash of the distance
matrix instead of the original object. Any distance objects are hashed before
comparison.
}
\details{
Note that the distance is hashed with its \code{call} set to \code{NULL}.
(This avoids issues where, for example, \code{match_on(Z~X, data=d,
caliper=NULL)} and \code{match_on(Z~X, data=d)} produce identical matches but
have differing \code{call}s.)
}
