% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{plotvertical}
\alias{plotvertical}
\title{Plot Custom Vertical Spread}
\usage{
plotvertical(options = c("call", "put"), s, x1, x2, t, r, sigma,
  sigma2 = sigma, d = 0, ll = 0.75, ul = 1.25, xlab = "spot",
  ylab = "profit/loss", main = "Vertical Spread", ...)
}
\arguments{
\item{options}{String argument, either "call" or "put"}

\item{s}{Spot price of the underlying asset}

\item{x1}{Short strike (either higher or lower)}

\item{x2}{Long strike (either higher or lower)}

\item{t}{Time to expiration in years}

\item{r}{Annual continuously compounded risk-free rate}

\item{sigma}{Annualized implied volatility of the short option}

\item{sigma2}{Annualized implied volatility of the long option}

\item{d}{Annual continuously compounded dividend yield}

\item{ll}{Lower-limit of the plot, set as (desired price/spot)}

\item{ul}{Upper-limit of the plot, set as (desired price/spot)}

\item{xlab}{X-Axis Label}

\item{ylab}{Y-Axis Label}

\item{main}{Title of the plot}

\item{...}{Additional plot parameters}
}
\value{
Returns a plot of a custom vertical spread.
Black line: The profit(loss) at expiration.
Red line: The profit(loss) at (1/2) time "t" ~ half-way to expiration.
Blue line: The profit(loss) at inception.
}
\description{
Plot Custom Vertical Spread
}
\examples{
plotvertical("call", 100, 90, 110, (45/365), 0.02, 0.20)
}
\author{
John T. Buynak
}
