% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{compile}
\alias{compile}
\alias{compile.ProjectProblem}
\title{Compile a problem}
\usage{
compile(x, ...)

\method{compile}{ProjectProblem}(x, ...)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{...}{not used.}
}
\value{
\code{\link{OptimizationProblem-class}} object.
}
\description{
Compile a project prioritization \code{\link{problem}} into a general
purpose format for optimization.
}
\details{
This function might be useful for those interested in understanding
  how their project prioritization \code{\link{problem}} is expressed
  as a mathematical problem. However, if the problem just needs to
  be solved, then the \code{\link{solve}} function should be used instead.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with maximum richness objective, $200 budget, and
# binary decisions
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions()

# print problem
print(p)

# compile problem
o <- compile(p)

# print compiled problem
print(o)
}
