% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugixml.R
\name{pugixml}
\alias{pugixml}
\alias{xml_node}
\alias{xml_node_name}
\alias{xml_value}
\alias{xml_attr}
\title{xml_node}
\usage{
xml_node(xml, level1 = NULL, level2 = NULL, level3 = NULL, ...)

xml_node_name(xml, level1 = NULL, level2 = NULL, ...)

xml_value(xml, level1 = NULL, level2 = NULL, level3 = NULL, ...)

xml_attr(xml, level1 = NULL, level2 = NULL, level3 = NULL, ...)
}
\arguments{
\item{xml}{something xml}

\item{level1}{to please check}

\item{level2}{to please check}

\item{level3}{to please check}

\item{...}{additional arguments passed to \code{read_xml()}}
}
\description{
returns xml values as character
}
\details{
This function returns XML nodes as used in openxlsx2. In theory they
could be returned as pointers as well, but this has not yet been implemented.
If no level is provided, the nodes on level1 are returned
}
\examples{
  x <- read_xml("<a><b/></a>")
  # return a
  xml_node(x, "a")
  # return b. requires the path to the node
  xml_node(x, "a", "b")
  xml_node_name("<a/>")
  xml_node_name("<a><b/></a>", "a")
  x <- read_xml("<a>1</a>")
  xml_value(x, "a")

  x <- read_xml("<a><b r=\"1\">2</b></a>")
  xml_value(x, "a", "b")

  x <- read_xml("<a a=\"1\" b=\"2\">1</a>")
  xml_attr(x, "a")

  x <- read_xml("<a><b r=\"1\">2</b></a>")
  xml_attr(x, "a", "b")
  x <- read_xml("<a a=\"1\" b=\"2\">1</a>")
  xml_attr(x, "a")

  x <- read_xml("<b><a a=\"1\" b=\"2\"/></b>")
  xml_attr(x, "b", "a")
}
