% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-smoking.R
\docType{data}
\name{smoking}
\alias{smoking}
\title{UK Smoking Data}
\format{
A data frame with 1691 observations on the following 12 variables.
\describe{
\item{gender}{Gender with levels \code{Female} and \code{Male}.}
\item{age}{Age.}
\item{marital_status}{Marital status with levels \code{Divorced},
\code{Married}, \code{Separated}, \code{Single} and \code{Widowed}.}
\item{highest_qualification}{Highest education level with levels
\code{A Levels}, \code{Degree}, \code{GCSE/CSE}, \code{GCSE/O Level},
\code{Higher/Sub Degree}, \code{No Qualification}, \code{ONC/BTEC} and
\code{Other/Sub Degree}}
\item{nationality}{Nationality with levels \code{British}, \code{English},
\code{Irish}, \code{Scottish}, \code{Welsh}, \code{Other}, \code{Refused}
and \code{Unknown}.}
\item{ethnicity}{Ethnicity with levels \code{Asian}, \code{Black},
\code{Chinese}, \code{Mixed}, \code{White} and \code{Refused}
\code{Unknown}.}
\item{gross_income}{Gross income with levels \code{Under 2,600},
\code{2,600 to 5,200}, \code{5,200 to 10,400}, \code{10,400 to 15,600},
\code{15,600 to 20,800}, \code{20,800 to 28,600}, \code{28,600 to 36,400},
\code{Above 36,400}, \code{Refused} and \code{Unknown}.}
\item{region}{Region with levels \code{London}, \code{Midlands & East Anglia},
\code{Scotland}, \code{South East}, \code{South West}, \code{The North}
and \code{Wales}}
\item{smoke}{Smoking status with levels \code{No} and \code{Yes}}
\item{amt_weekends}{Number of cigarettes smoked per day on weekends.}
\item{amt_weekdays}{Number of cigarettes smoked per day on weekdays.}
\item{type}{Type of cigarettes smoked with levels \code{Packets},
\code{Hand-Rolled}, \code{Both/Mainly Packets} and \code{Both/Mainly Hand-Rolled}}
}
}
\source{
National STEM Centre, Large Datasets from stats4schools,
\url{https://www.stem.org.uk/resources/elibrary/resource/28452/large-datasets-stats4schools}.
}
\usage{
smoking
}
\description{
Survey data on smoking habits from the UK. The data set can be used for
analyzing the demographic characteristics of smokers and types of tobacco
consumed.
}
\examples{

library(ggplot2)

ggplot(smoking, aes(x = amt_weekends)) +
  geom_histogram(binwidth = 5)

ggplot(smoking, aes(x = amt_weekdays)) +
  geom_histogram(binwidth = 5)

ggplot(smoking, aes(x = gender, fill = smoke)) +
  geom_bar(position = "fill")

ggplot(smoking, aes(x = marital_status, fill = smoke)) +
  geom_bar(position = "fill")

}
\keyword{datasets}
\keyword{smoking}
