% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMeta.R
\name{importMeta}
\alias{importMeta}
\title{Import monitoring site meta data for the UK and European networks}
\usage{
importMeta(source = "aurn", all = FALSE, duplicate = FALSE)
}
\arguments{
\item{source}{One or more sources of meta data. Can be \code{aurn}, \code{saqn} (or
\code{saqd}), \code{aqe}, \code{waqn}, \code{ni}, \code{local} (or \code{lmam}), \code{kcl} or \code{europe}; upper
or lower case.}

\item{all}{When \code{all = FALSE} only the site code, site name, latitude and
longitude and site type are imported. Setting \code{all = TRUE} will import all
available meta data and provide details (when available) or the individual
pollutants measured at each site.}

\item{duplicate}{Some UK air quality sites are part of multiple networks, so
could appear more than once when \code{source} is a vector of two or more. The
default argument, \code{FALSE}, drops duplicate sites. \code{TRUE} will return them.}
}
\value{
A data frame with meta data.
}
\description{
Function to import meta data for air quality monitoring sites
}
\details{
This function imports site meta data from several networks in the UK and
Europe:
\itemize{
\item \code{"aurn"},  The UK Automatic Urban and Rural Network.
\item \code{"saqn"},  The Scottish Air Quality Network.
\item \code{"waqn"},  The Welsh Air Quality Network.
\item \code{"ni"},  The Northern Ireland Air Quality Network.
\item \code{"aqe"},  The Air Quality England Network.
\item \code{"local"},  Locally managed air quality networks in England.
\item \code{"kcl"},  King's College London networks.
\item \code{"europe"},  Import hourly European data (Airbase/e-reporting) based on a
simplified version of the \code{saqgetr} package.
}

By default, the function will return the site latitude, longitude and site
type. If the option \code{all = TRUE} is used, much more detailed information is
returned. For most networks, this detailed information includes per-pollutant
summaries, opening and closing dates of sites etc.

Thanks go to Trevor Davies (Ricardo), Dr Stuart Grange (EMPA) and Dr Ben
Barratt (KCL) and  for making these data available.
}
\examples{
## basic data

\dontrun{
meta <- importMeta(source = "aurn")

# more detailed information:
meta <- importMeta(source = "aurn", all = TRUE)

# from the Scottish Air Quality Network
meta <- importMeta(source = "saqn", all = TRUE)

# from multiple networks
meta <- importMeta(source = c("aurn", "aqe", "local"))
}
}
\seealso{
the \code{networkMap()} function from the \code{openairmaps} package which can
visualise site metadata

Other import functions: 
\code{\link{importADMS}()},
\code{\link{importAQE}()},
\code{\link{importAURN}()},
\code{\link{importEurope}()},
\code{\link{importKCL}()},
\code{\link{importLocal}()},
\code{\link{importNI}()},
\code{\link{importSAQN}()},
\code{\link{importTraj}()},
\code{\link{importWAQN}()}
}
\author{
David Carslaw
}
\concept{import functions}
