\name{openair-package}
\alias{openair-package}
\alias{openair}
\docType{package}
\title{Tools for the analysis of air pollution data}

\description{ This is a UK Natural Environment Research Council (NERC)
funded knowledge exchange project that aims to make available innovative
analysis tools for air pollution data; with additional support from
Defra.  The tools have generally been developed to analyse data of at
least hourly resolution both for air pollution monitoring and dispersion
modelling. The availability of meteorological data at the same time
resolution greatly enhances the capabilities of these tools.

The project itself is currently funded until October 2011. Up until that
time the development will carried out on R-Forge
(\url{http://r-forge.r-project.org/projects/openair/}).}

\details{
  \tabular{ll}{
    Package: \tab openair\cr
    Type: \tab Package\cr
    Version: \tab 0.4-15\cr
    Date: \tab 2011-04-12\cr
    License: \tab GPL\cr
    LazyLoad: \tab yes\cr }

\code{openair} contains collection of functions to analyse air pollution
data. Typically it is expected that data are hourly means, although most
functions consider other time periods. The principal aim to make
available analysis techniques that most users of air quality data and
model output would not normally have access to. The functions consist of
those developed by the authors and a growing number from other
researchers.

The package has a number of requirements for input data and these are
discussed in the manual (available on the openair website). The key
requirements are that a date or date-time field must have the name
`date' (and can be \code{Date} or \code{POSIXct} format), that wind
speed is represented as `ws' and that wind direction is `wd'.

Most functions work in a very straightforward way, but offer many
options for finer control and perhaps more in-depth analysis.

The \code{openair} package depends on several other packages written by
other people to function properly.

To ensure that these other packages are available, they need to be
installed, and this requires a connection to the internet. Other
packages required come with the R base system. This can be done by
pasting the text below into R.

install.packages(c("zoo", "reshape", "plyr", "RColorBrewer", "proto"))

If there are problems with the automatic download of these packages, see
\url{http://www.openair-project.org} for more details.

NOTE: openair assumes that data are not expressed in local time where
'Daylight Saving Time' is used. All functions check that this is the
case and issue a warning if TRUE. It is recommended that data are
expressed in UTC/GMT to avoid potential problems with R and openair
functions.

To check to see if \code{openair} has been correctly installed, try some
of the examples below. In case of any problems, contact David Carslaw
\url{mailto: david.carslaw@kcl.ac.uk} or Karl Ropkins \url{mailto:
k.ropkins@its.leeds.ac.uk} directly.

}
\author{
David Carslaw and Karl Ropkins

Maintainer: David Carslaw <david.carslaw@kcl.ac.uk>

}
\references{
Most reference details are given under the specific functions.

Carslaw, D.C. and K. Ropkins (2011). Open-source tools for analysing air
pollution data. King's College London and the University of Leeds.  }
\keyword{methods}

\seealso{See \url{http://www.openair-project.org} for up to date information on
  the project.  }

\examples{
# load example data from package
data(mydata)

# summarise the data in a compact way
\dontrun{summaryPlot(mydata)}

# traditional wind rose
windRose(mydata)

# basic plot
\dontrun{polarPlot(mydata, pollutant = "nox")}
}
