% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSMF.r
\name{getTopCOD}
\alias{getTopCOD}
\title{Extract the most likely cause of death}
\usage{
getTopCOD(x, interVA.rule = TRUE)
}
\arguments{
\item{x}{a fitted object from \code{codeVA}.}

\item{interVA.rule}{Logical indicator for \code{interVA} object only. If TRUE, 
only the InterVA reported first cause is extracted.}
}
\value{
a data frame of ID and most likely cause assignment.
}
\description{
Extract the most likely cause of death
}
\examples{
data(RandomVA1)
# for illustration, only use interVA on 100 deaths
fit <- codeVA(RandomVA1[1:100, ], data.type = "WHO", model = "InterVA", 
                  version = "4.02", HIV = "h", Malaria = "l", write=FALSE)
getTopCOD(fit)

}
