% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_prediction_sites.R
\name{calc_offset}
\alias{calc_offset}
\title{Calculate offset}
\usage{
calc_offset(dt, id, offs, dist)
}
\arguments{
\item{dt}{data.table containing the attributes of the stream segments}

\item{id}{integer; 'stream' of the stream segment}

\item{offs}{number; offset from outlet of the stream segment (downstream);
equals the length of the segment if the point shall be placed directly at the
downstream junction.}

\item{dist}{number giving the distance between the points to create in map units.}
}
\value{
Nothing; change 'offset' in dt.
}
\description{
Recursive function to calculate the offset from the downstream
junction needed to place points with fixed distance along the streams.
It is called by \code{\link{calc_prediction_sites}} for each
outlet and should not be called by the user.
}
\examples{
\dontrun{
 outlets <- dt.streams[next_str == -1, stream]
 netID <- 1
 for(i in outlets){
   calc_offset(dt.streams, id = i, offs = 0, dist = 200)
 }
}
}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}
}
\keyword{internal}
