/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class SpeechPronounResolver
extends MaxentResolver {
    public SpeechPronounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "fmodel", m, 30);
        this.numSentencesBack = 0;
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    public SpeechPronounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "fmodel", m, 30, nrr);
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(this.getPronounMatchFeatures(mention, entity));
            List contexts = SpeechPronounResolver.getContextFeatures(mention);
            MentionContext cec = entity.getLastExtent();
            if (mention.getHeadTokenTag().startsWith("PRP") && cec.getHeadTokenTag().startsWith("PRP")) {
                features.add(mention.getHeadTokenText() + "," + cec.getHeadTokenText());
            } else if (mention.getHeadTokenText().startsWith("NNP")) {
                int cl = contexts.size();
                for (int ci = 0; ci < cl; ++ci) {
                    features.add((String)contexts.get(ci));
                }
                features.add(mention.getNameType() + "," + cec.getHeadTokenText());
            } else {
                List ccontexts = SpeechPronounResolver.getContextFeatures(cec);
                int cl = ccontexts.size();
                for (int ci = 0; ci < cl; ++ci) {
                    features.add((String)ccontexts.get(ci));
                }
                features.add(cec.getNameType() + "," + mention.getHeadTokenText());
            }
        }
        return features;
    }

    protected boolean outOfRange(MentionContext mention, DiscourseEntity entity) {
        MentionContext cec = entity.getLastExtent();
        return mention.getSentenceNumber() - cec.getSentenceNumber() > this.numSentencesBack;
    }

    public boolean canResolve(MentionContext mention) {
        String tag = mention.getHeadTokenTag();
        boolean fpp = tag != null && tag.startsWith("PRP") && Linker.speechPronounPattern.matcher(mention.getHeadTokenText()).matches();
        boolean pn = tag != null && tag.startsWith("NNP");
        return fpp || pn;
    }

    protected boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        MentionContext cec = entity.getLastExtent();
        if (!this.canResolve(cec)) {
            return true;
        }
        if (mention.getHeadTokenTag().startsWith("NNP")) {
            if (cec.getHeadTokenTag().startsWith("NNP")) {
                return true;
            }
            if (entity.getNumMentions() > 1) {
                return true;
            }
            return !this.canResolve(cec);
        }
        if (mention.getHeadTokenTag().startsWith("PRP")) {
            if (cec.getHeadTokenTag().startsWith("NNP")) {
                return mention.getSentenceNumber() - cec.getSentenceNumber() != 0;
            }
            if (cec.getHeadTokenTag().startsWith("PRP")) {
                return false;
            }
            System.err.println("Unexpected candidate exluded: " + cec.toText());
            return true;
        }
        System.err.println("Unexpected mention exluded: " + mention.toText());
        return true;
    }
}

