% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_perm_delete}
\alias{opal.table_perm_delete}
\title{Delete a permission from a table}
\usage{
opal.table_perm_delete(opal, project, table, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{table}{Destination table name.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}
}
\description{
Delete a permission that was applied on a table. Silently returns when there is no such permission.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.table_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.table_perm(o, 'CNSIM', 'CNSIM1')
opal.table_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()}
}
\concept{table functions}
