% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildConfInt.R
\name{buildConfInt}
\alias{buildConfInt}
\title{Calculate a confidence interval for the R²}
\usage{
buildConfInt(oosseObj, what = c("R2", "MSE"), conf = 0.95)
}
\arguments{
\item{oosseObj}{The result of the R2oosse call}

\item{what}{For which property should the ci be found: R² (default), MSE or MST}

\item{conf}{the confidence level required}
}
\value{
A vector of length2 with lower and upper bound of the confidence interval
}
\description{
Calculate a confidence interval for the R²
}
\details{
The upper bound of the interval is truncated at 1 for the R² and
the lower bound at 0 for the MSE
}
\examples{
data(Brassica)
fitFunLM = function(y, x){lm.fit(y = y, x = cbind(1, x))}
predFunLM = function(mod, x) {cbind(1,x) \%*\% mod$coef}
R2lm = R2oosse(y = Brassica$Pheno$Leaf_8_width, x = Brassica$Expr[, 1:10],
fitFun = fitFunLM, predFun = predFunLM, nFolds = 5)
# A higher number of folds (e.g. 10) is recommended if computational resources allow
buildConfInt(R2lm)
}
\seealso{
\link{R2oosse}
}
