% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{path_hamming_over_all_edges}
\alias{path_hamming_over_all_edges}
\title{Hamming distances for a tree}
\usage{
path_hamming_over_all_edges(tree.merge)
}
\arguments{
\item{tree.merge}{simmap object. A discretized simmap using the 'discr_Simmap' function where identical state bins were merged using the 'merge_tree_cat' function.}
}
\value{
A tibble with information on state changes, time spent on each state, edge IDs, absolute and normalized hamming distances for all edges in a tree.
}
\description{
Calculates hamming distances for all paths in a given discretized tree.
}
\examples{
data("hym_stm_amalg")
# Get one sample of stochastic maps from head.
tree <- hym_stm_amalg$head[[1]]
tree <- merge_tree_cat(tree)
\donttest{

  # Calculate hamming distances.
  ph <- suppressWarnings(path_hamming_over_all_edges(tree))
  ph

}

}
\author{
Sergei Tarasov
}
