% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphospace_functions.R
\name{add_noise_MD}
\alias{add_noise_MD}
\title{Adding noise to MDS from one stochastic character map}
\usage{
add_noise_MD(MD, add.noise)
}
\arguments{
\item{MD}{tibble. The output of a MD_morpho function.}

\item{add.noise}{numeric. A vector of length 2 indicating the amount of noise to be added to the x and y coordinates.}
}
\value{
A list of tibbles as in the output of MD_morpho functions, with noise added.
}
\description{
Adds noise to the points in the 2D coordinates in the MDS plot.
# The noise is calculated as var(V)*add.noise.
}
\examples{
data("hym_stm_mds")
# Select a few taxa from main lineages of Hymenoptera.
tax <- c("Xyela", "Tenthredo", "Orussus", "Pimpla",
         "Ceraphron", "Evania", "Pison",
         "Ibalia", "Proctotrupes", "Chiloe") 
drop_tax <- hym_stm_mds$tip.label[!hym_stm_mds$tip.label \%in\% tax]
hym_stm_mds <- phytools::drop.tip.simmap(hym_stm_mds, drop_tax)
# Get a sample of amalgamated stochastic map (phenome).
tree <- merge_tree_cat(hym_stm_mds)

\donttest{

  # Multidimensional scaling for an arbitrary tree.
  MD <- suppressWarnings(MultiScale.simmap(tree))

  # Add noise.
  add_noise_MD(MD, c(0.3, 0.3))

}

}
\author{
Sergei Tarasov
}
