% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_source.R
\name{get_source}
\alias{get_source}
\title{Get source(e) in an ontology}
\usage{
get_source(..., regex = FALSE, ontology = NULL)
}
\arguments{
\item{...}{combination of column name and value to filter that column by. The
value to filter by can be provided as regular expression, if \code{regex =
  TRUE}.}

\item{regex}{\code{\link[=logical]{logical(1)}}\cr whether or not the value in
\code{...} shall be matched in full, or whether any partial match should be
returned.}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}
}
\value{
A table of the source(s) in the ontology according to the values in
\code{...}
}
\description{
Get source(e) in an ontology
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

# exact sources from a loaded ontology ...
get_source(label = "harmonised", ontology = onto)

# ... or one stored on the harddisc
get_source(version = "0.0.1", ontology = ontoDir)

# get all sources
get_source(ontology = onto)
}
