% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.list.R
\name{check.data.list}
\alias{check.data.list}
\title{Checking the data.list for appropriate form.}
\usage{
\method{check}{data.list}(object)
}
\arguments{
\item{object}{The object to be checked.}
}
\value{
The tables generated.

# Check a data.list (see \code{?\link{check.data.list}})
check(Dbuilding)

# Vector with observations not same length as t
D <- Dbuilding
D$heatload <- D$heatload[1:10]
check(D)

# Some NAs in k1 forecast
D <- Dbuilding
D$Ta$k1[1:1500] <- NA
check(D)

# Wrong column names
names(D$Ta)
}
\description{
Checking the data.list for appropriate form.
}
\details{
Prints a check of the time vector t, which must have equidistant time points and no NAs.

Then the results of checking vectors (observations):
  - ok: A 'V' indicates a successful check
  - maxNAs: Proportion of NAs
  - length: printed if not the same as the 't' vector
  - class: the class

Then the results of checking data.frames and matrices (forecasts):
  - ok: a 'V' indicates a successful check
  - maxNAs: the proportion of NAs for the horizon (i.e. column) with the highest proportion of NAs
  - meanNAs: the proportion of NAs of the entire data.frame
  - nrow: printed if not the same as the 't' vector length
  - colnames: columns must be names 'kxx', where 'xx' is the horizon
  - sameclass: 'X' if not all columns are the same class
  - class: prints the class of the columns if they are all the same
}
