% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rls_optim.R
\name{rls_optim}
\alias{rls_optim}
\title{Optimize parameters for onlineforecast model fitted with RLS}
\usage{
rls_optim(
  model,
  data,
  scorefun = rmse,
  cachedir = "",
  printout = TRUE,
  method = "L-BFGS-B",
  ...
)
}
\arguments{
\item{model}{The onlineforecast model, including inputs, output, kseq, p}

\item{data}{The data.list including the variables used in the model.}

\item{scorefun}{The function to be score used for calculating the score to be optimized.}

\item{cachedir}{A character specifying the path (and prefix) of the cache file name. If set to \code{""}, then no cache will be loaded or written. See \url{https://onlineforecasting.org/vignettes/nice-tricks.html} for examples.}

\item{printout}{A logical determining if the score function is printed out in each iteration of the optimization.}

\item{method}{The method argument for \code{\link{optim}}.}

\item{...}{Additional parameters to \code{\link{optim}}}
}
\value{
Result object of optim().
Parameters resulting from the optimization can be found from \code{result$par}
}
\description{
Optimize parameters (transformation stage) of RLS model
}
\details{
This is a wrapper for \code{\link{optim}} to enable easy use of bounds and caching in the optimization.

One smart trick, is to cache the optimization results. Caching can be done by providing a path to the
\code{cachedir} argument (relative to the current working directory).
E.g. \code{rls_optim(model, D, cachedir="cache")} will write a file in the folder 'cache', such that
next time the same call is carried out, then the file is read instead of running the optimization again.
See the example in url{https://onlineforecasting.org/vignettes/nice-tricks.html}.
}
\examples{

# Take data
D <- subset(Dbuilding, c("2010-12-15", "2011-01-01"))
D$y <- D$heatload
# Define a simple model 
model <- forecastmodel$new()
model$add_inputs(Ta = "Ta", mu = "one()")
model$add_regprm("rls_prm(lambda=0.99)")

# Before fitting the model, define which points to include in the evaluation of the score function
D$scoreperiod <- in_range("2010-12-20", D$t)
# And the sequence of horizons to fit for
model$kseq <- 1:6
# Now we can fit the model and get the score, as it is
rls_fit(model=model, data=D, scorefun=rmse, returnanalysis=FALSE)
# Or we can change the lambda
rls_fit(c(lambda=0.9), model, D, rmse, returnanalysis=FALSE)

# This could be passed to optim() (or any optimizer, see forecastmodel$insert_prm()).
optim(c(lambda=0.98), rls_fit, model=model, data=D, scorefun=rmse, returnanalysis=FALSE,
      lower=c(lambda=0.9), upper=c(lambda=0.999), method="L-BFGS-B")

# rls_optim is simply a helper, it's makes using bounds easiere and enables caching of the results
# First add bounds for lambda (lower, init, upper)
model$add_prmbounds(lambda = c(0.9, 0.98, 0.999))

# Now the same optimization as above can be done by
val <- rls_optim(model, D)
val


}
\seealso{
\code{link{optim}} for how to control the optimization.
}
