\name{WalBelSentiment}
\alias{WalBelSentiment}
\alias{WalBelEmotions}
\alias{WalBelTimes}
\docType{data}
\title{
Sentiment and Emotion Annotated Twitter Data from the Wales versus Belgium 2016 Euro Cup Soccer Game
}
\description{
A sample of one of the data sets used while creating and testing the package. 
Data was obtained by trawling Twitter for all tweets related to the Wales vs Belgium game. Sentiment and Emotion data was generated by the NRC Sentiment Annotator. Finally, tweets were bucketed in 5 second buckets to smooth the data a little. 
}
\usage{data("WalBelSentiment")}
\format{
  The format is:
 num [1:2040, 1:3] 0.222 0.217 0.214 0.23 0.252 ...
 - attr(*, "dimnames")=List of 2
  ..$ : NULL
  ..$ : chr [1:3] "neg" "neu" "pos"
}
\details{
WalBelSentiment: a matrix of sentiment values, obtained from the NRC Sentiment Annotator. Each row is one 5 second bucket of tweets, and each column is one of Negative, Neutral or Positive sentiment. The values in each row sum to 1.

WalBelEmotions: a matrix of emotion values, obtained from the NRC Sentiment Annotator. Each row is one 5 second bucket of tweets, and each column is one of Anger, Fear, Dislike, Sadness, Surprise, or Joy. Values do not sum to 1 and are independent of each other.

WalBelTimes: a vector of times corresponding to the buckets in the Sentiment and Emotions Matrices above. Included for pretty-printing the x-axis in the onlineCPD or offlineCPD plot.
}
\source{
Twitter

NRC Sentiment Annotator
}
\examples{
\dontrun{
data(WalBelSentiment)
data(WalBelTimes)

plot(offlineCPD(WalBelSentiment[1000:1600,],WalBelTimes[1000:1600]),
title="oCPD on Sentiment in the Wales vs Belgium Game")}
}
\keyword{datasets}
