% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{onetime_message_confirm}
\alias{onetime_message_confirm}
\title{Print a message, and ask for confirmation to hide it in future}
\usage{
onetime_message_confirm(
  message,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  confirm_prompt = "Show this message again? [yN] ",
  confirm_answers = c("N", "n", "No", "no"),
  default_answer = "N",
  require_permission = FALSE,
  without_permission = "warn"
)
}
\arguments{
\item{message}{Message to display to the user.}

\item{id}{Unique ID string. By default, name of the calling package.}

\item{path}{Directory to store lockfiles.}

\item{expiry}{\code{\link[=difftime]{difftime()}} or e.g. \code{\link[lubridate:duration]{lubridate::duration()}} object.
After this length of time, code will be run again.}

\item{confirm_prompt}{Character string. Question to prompt the user to hide
the message in future.}

\item{confirm_answers}{Character vector. Answers which will cause
the message to be hidden in future.}

\item{default_answer}{Character string. Default answer if user
simply presses return.}

\item{require_permission}{Logical. Ask permission to store files on the user's
computer, if this hasn't been granted? Setting this to \code{FALSE}
overrides \code{without_permission}.}

\item{without_permission}{Character string. What to do if the user hasn't
given permission to store files? \code{"warn"} runs the action with an extra
warning; \code{"run"} runs the action; \code{"pass"} does nothing and returns the
default; \code{"stop"} throws an error; \code{"ask"} asks for permission, after
running the action but before recording it on disk.}
}
\value{
\code{NULL} if the message was not shown (shown already or non-interactive
session). \code{TRUE} if the user confirmed (i.e. asked to hide the message).
\code{FALSE} if the message was shown but the user did not confirm. Note that by
default, \code{TRUE} is returned when the user answers "no" to "Show this message
again?"
}
\description{
This uses \code{\link[=readline]{readline()}} to ask the user if the message should
be shown again in future. In a non-interactive session, it does
nothing.
}
\details{
By default, the message will be hidden if the user answers
"n", "No", or "N", or just presses return to the prompt question.

Unlike other \code{onetime} functions, \code{onetime_message_confirm()} doesn't by
default require permission to store files on the user's computer. The
assumption is that saying "Don't show this message again" counts as
granting permission (just for this one message). You can ask for broader
permission by setting \code{require_permission = TRUE} and
\code{without_permission = "ask"}.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1L)

onetime_message_confirm("A message to show one or more times", id = id)

onetime_reset(id = id)
options(oo)
}
