% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visits_to_mstate.R
\name{visits_to_mstate}
\alias{visits_to_mstate}
\title{Convert cross-sectional visit data to multi-state format}
\usage{
visits_to_mstate(tbl_visits, model, now = max(tbl_visits$t))
}
\arguments{
\item{tbl_visits}{data frame, visit data in long format}

\item{model}{an object of class \link{srpmodel} containing prior information}

\item{now}{time point since start of trial (might be later than last
recorded visit)}
}
\value{
A data frame with multi-state data; variables are
\verb{subject_id<chr>}, \verb{group_id<chr>}, \verb{subject_id<chr>}, \verb{from<chr>},
\verb{to<chr>}, \verb{t_min<dbl>}, \verb{t_max<dbl>}, \verb{t_sot<dbl>}, where
\code{to} and \code{from} indicate the state from which and into which the transitions
occurs, \code{t_max} and \code{t_min} specify the
interval in which the transition occurred relative to \code{t_sot}
(start of treatment).
}
\description{
\code{visits_to_mstate()} converts visits to interval-censored multi-state
data where each row corresponds to a transition between states.
The conversion assumes that visit spacing is tight enough to not miss any
transitions.
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
tbl_visits <- sample_predictive(mdl, n_per_group = 5L, nsim = 1, seed = 468L)
visits_to_mstate(tbl_visits, mdl)

}
