% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_add_doc_content.R
\name{report_add_doc_content}
\alias{report_add_doc_content}
\title{Add Content to Body of a Word Document Report}
\usage{
report_add_doc_content(
  obnd,
  type = NULL,
  content = NULL,
  fig_start_at = NULL,
  tab_start_at = NULL,
  verbose = TRUE
)
}
\arguments{
\item{obnd}{onbrand report object}

\item{type}{Type of content to add}

\item{content}{Content to add}

\item{fig_start_at}{Indicates that you want to restart figure numbering at
the specified value (e.g. 1) after adding this content a value of \code{NULL} (default)
will ignore this option.}

\item{tab_start_at}{Indicates that you want to restart figure numbering at
the specified value (e.g. 1) after adding this content a value of \code{NULL} (default)
will ignore this option.}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned onbrand
object.}
}
\value{
onbrand object with the content added to the body or isgood set
to FALSE with any messages in the msgs field.
}
\description{
Appends content to the body of a Word document
}
\details{
For each \code{content} types listed below the different \code{content} outlined is expected. Text
can be specified in different formats: \code{"text"} indicates plain text,
\code{"fpar"} is formatted text defined by the \code{fpar} command from the
\code{officer} package, \code{"ftext"} is alist of formatted text defined
by the \code{ftext} command, and \code{"md"} is text formatted in markdown
format (\code{?md_to_officer} for markdown details).

\itemize{
 \item \code{"break"} page break, content is (\code{NULL}) and a page break will be inserted here
 \item \code{"ph"} adds placeholder text substitution
  \itemize{
     \item \code{"name"} placeholder name (value in body of text surrounded by three equal signs, e.g. if you have \code{"===MYPH==="}. in the document the name is just \code{"MYPH"})
     \item \code{"value"} value to be substituted into the placeholder (\code{"my text"})
     \item \code{"location"} document location where the placeholder will be located (either \code{"header"}, \code{"footer"}, or \code{"body"})
   }
 \item \code{"toc"} generates the table of contents, and content is a list
 that must contain __one__ of the following. 
  \itemize{
     \item \code{"level"} number indicating the depth of the contents to display (default: \code{3})
     \item \code{"style"} string containing the onbrand style name to use to build the TOC
   }
 \item \code{"section"} formats the current document section
  \itemize{
     \item \code{"section_type"} type of section to apply, either \code{"columns"},  \code{"continuous"}, \code{"landscape"}, \code{"portrait"}, \code{"columns"},  or  \code{"columns_landscape"}
     \item \code{"width"}        override the default page width with this value in inches (\code{NULL})
     \item \code{"height"}       override the default page height with this value in inches (\code{NULL})
     \item \code{"widths"}       column widths in inches, number of columns set by number of values (\code{NULL})
     \item \code{"space"}        space in inches between columns (\code{NULL})
     \item \code{"sep"}          Boolean value controlling line separating columns (\code{FALSE})
   }
 \item \code{"text"} content is a list containing a paragraph of text with the following elements
  \itemize{
     \item \code{"text"} string containing the text content either a string or the output of \code{"fpar"} for formatted text.
     \item \code{"style"} string containing the style to use (default \code{NULL} will use the \code{doc_def}, \code{Text} style)
     \item \code{"format"} string containing the format, either \code{"text"}, \code{"fpar"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
   }
 \item \code{"imagefile"} content is a list containing information describing an image file with the following elements
  \itemize{
     \item \code{image} string containing path to image file
     \item \code{caption} caption of the image (\code{NULL})
     \item \code{caption_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{notes} notes to add under the image  (\code{NULL})
     \item \code{notes_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{key} unique key for cross referencing e.g. "FIG_DATA" (\code{NULL})
     \item \code{height} height of the image (\code{NULL})
     \item \code{width} width of the image (\code{NULL})
   }
 \item \code{"ggplot"} content is a list containing a ggplot object, (eg. p = ggplot() + ....) with the following elements
  \itemize{
     \item \code{image} ggplot object
     \item \code{caption} caption of the image (\code{NULL})
     \item \code{caption_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{notes} notes to add under the image  (\code{NULL})
     \item \code{notes_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{key} unique key for cross referencing e.g. "FIG_DATA" (\code{NULL})
     \item \code{height} height of the image (\code{NULL})
     \item \code{width} width of the image (\code{NULL})
   }
 \item \code{"table"} content is a list containing the table content and other options with the following elements:
  \itemize{
     \item \code{table} data frame containing the tabular data
     \item \code{"style"} string containing the style to use (default \code{NULL} will use the \code{doc_def}, \code{Table} style)
     \item \code{caption} caption of the table (\code{NULL})
     \item \code{caption_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{notes} notes to add under the image  (\code{NULL})
     \item \code{notes_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{key} unique key for cross referencing e.g. "TAB_DATA" (\code{NULL})
     \item \code{header} Boolean variable to control displaying the header (\code{TRUE})
     \item \code{first_row} Boolean variable to indicate that the first row contains header information (\code{TRUE})
   }
 \item \code{"flextable"} content is a list containing flextable content and other options with the following elements (defaults in parenthesis):
  \itemize{
     \item \code{table} data frame containing the tabular data
     \item \code{caption} caption of the table (\code{NULL})
     \item \code{caption_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{notes} notes to add under the image  (\code{NULL})
     \item \code{notes_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{key} unique key for cross referencing e.g. "TAB_DATA" (\code{NULL})
     \item \code{header_top}, \code{header_middle}, \code{header_bottom} (\code{NULL}) a list with the same names as the data frame names containing the tabular data and values with the header text to show in the table
     \item \code{header_format} string containing the format, either \code{"text"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{merge_header} (\code{TRUE}) Set to true to combine column headers with the same information
     \item \code{table_body_alignment}, table_header_alignment ("center") Controls alignment
     \item \code{table_autofit} (\code{TRUE}) Automatically fit content, or specify the cell width and height with \code{cwidth} (\code{0.75}) and \code{cheight} (\code{0.25})
     \item \code{table_theme} (\code{"theme_vanilla"}) Table theme
   }
 \item \code{"flextable_object"} content is a list specifying the a user defined flextable object with the following elements:
  \itemize{
     \item \code{ft} flextable object
     \item \code{caption} caption of the table (\code{NULL})
     \item \code{caption_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{notes} notes to add under the image  (\code{NULL})
     \item \code{notes_format} string containing the format, either \code{"text"}, \code{"ftext"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)
     \item \code{key} unique key for cross referencing e.g. "TAB_DATA" (\code{NULL})
   }
}
}
\examples{

# Read  Word template into an onbrand object
obnd = read_template(
 template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
 mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

# The examples below use the following packages
library(ggplot2)
library(flextable)
library(officer)

# Adding text
obnd = report_add_doc_content(obnd,
  type     = "text",
  content  = list(text="Text with no style specified will use the doc_def text format."))


# Text formatted with fpar
fpartext = fpar(
ftext("Formatted text can be created using the ", prop=NULL),
ftext("fpar ", prop=fp_text(color="green")),
ftext("command from the officer package.", prop=NULL))

obnd = report_add_doc_content(obnd,
 type     = "text",
 content  = list(text   = fpartext,
                 format = "fpar",
                 style  = "Normal"))

# Text formatted with markdown
mdtext = "Formatted text can be created using
**<color:green>markdown</color>** formatting"
obnd = report_add_doc_content(obnd,
 type     = "text",
 content  = list(text   = mdtext,
                 format = "md",
                 style  = "Normal"))


# Adding figures
p = ggplot() + annotate("text", x=0, y=0, label = "picture example")
imgfile = tempfile(pattern="image", fileext=".png")
ggsave(filename=imgfile, plot=p, height=5.15, width=9, units="in")

# From an image file:
obnd = report_add_doc_content(obnd,
type     = "imagefile",
content  = list(image   = imgfile,
               caption = "This is an example of an image from a file."))

# From a ggplot object
obnd = report_add_doc_content(obnd,
type     = "imagefile",
content  = list(image   = imgfile,
               caption = "This is an example of an image from a file."))


#Adding tables
tdf =    data.frame(Parameters = c("Length", "Width", "Height"),
                Values     = 1:3,
                Units      = c("m", "m", "m") )

# Word table
tab_cont = list(table   = tdf,
               caption = "Word Table.")
obnd = report_add_doc_content(obnd,
 type     = "table",
 content  = tab_cont)

# onbrand flextable abstraction:
tab_cont = list(table   = tdf,
               caption = "Word Table.")
obnd = report_add_doc_content(obnd,
type     = "table",
content  = tab_cont)

# flextable object
tab_fto = flextable(tdf)
obnd = report_add_doc_content(obnd,
 type     = "flextable_object",
 content  = list(ft=tab_fto,
                 caption  = "Flextable object created by the user."))

# Saving the report output
save_report(obnd, tempfile(fileext = ".docx"))

}
