% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renumSeq.r
\name{renumSeq}
\alias{renumSeq}
\title{Renumber a sequence of numbers}
\usage{
renumSeq(x)
}
\arguments{
\item{x}{Vector of numerical or character values.}
}
\value{
A vector.
}
\description{
This function renumbers a sequence, which is helpful if "gaps" appear in the sequence. For example, consider the sequence \code{{1, 1, 3, 1, 8, 8, 8}}. This function will renumber the sequence \code{{1, 1, 2, 1, 3, 3, 3}}. \code{NA}s are ignored.
}
\examples{

x <- c(1, 1, 3, 1, 8, 8, 8)
renumSeq(x)

x <- c(1, 1, 3, 1, 8, NA, 8, 8)
renumSeq(x)

y <- c('c', 'c', 'b', 'a', 'w', 'a')
renumSeq(y)

}
\seealso{
\code{\link{order}}, \code{\link{rank}}
}
