% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-dffits-plot.R
\name{ols_dffits_plot}
\alias{ols_dffits_plot}
\title{DFFITS Plot}
\usage{
ols_dffits_plot(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\value{
\code{ols_dffits_plot} returns  a list containing the
following components:

\item{outliers}{a tibble with observation number and \code{DFFITs} that exceed \code{threshold}}
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Plot for detecting influential observations using DFFITs.
}
\details{
DFFIT - difference in fits, is used to identify influential data points. It quantifies 
the number of standard deviations that the fitted value changes when the ith data point is omitted.

Steps to compute DFFITs:

\itemize{
  \item Delete observations one at a time.
  \item Refit the regression model on remaining \eqn{n - 1} observations
  \item examine how much all of the fitted values change when the ith observation is deleted.
}

An observation is deemed influential if the absolute value of its DFFITS value is greater than:
\deqn{2\sqrt(p + 1) / (n - p -1)}

where n is the number of observations and p is the number of predictors including intercept.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_dffits_plot(model)
}
\references{
Belsley, David A.; Kuh, Edwin; Welsh, Roy E. (1980). Regression 
Diagnostics: Identifying Influential Data and Sources of Collinearity. 
Wiley Series in Probability and Mathematical Statistics. 
New York: John Wiley & Sons. ISBN 0-471-05856-4.
}
