% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{generate}
\alias{generate}
\title{Generate a completion.}
\usage{
generate(
  model,
  prompt,
  stream = FALSE,
  output = c("resp", "jsonlist", "raw", "df"),
  endpoint = "/api/generate"
)
}
\arguments{
\item{model}{A character string of the model name such as "llama3".}

\item{prompt}{A character string of the promp like "The sky is..."}

\item{stream}{Enable response streaming. Default is FALSE.}

\item{output}{A character vector of the output format. Default is "resp". Options are "resp", "jsonlist", "raw", "df".}

\item{endpoint}{The endpoint to generate the completion. Default is "/api/generate".}
}
\value{
A response in the format specified in the output parameter.
}
\description{
Generate a response for a given prompt with a provided model.
}
\examples{
\dontshow{if (test_connection()$status_code == 200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
generate("llama3", "The sky is...", stream = FALSE, output = "df")
generate("llama3", "The sky is...", stream = TRUE, output = "df")
generate("llama3", "The sky is...", stream = FALSE, output = "jsonlist")
\dontshow{\}) # examplesIf}
}
