% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ohsome_query.R
\name{ohsome_query}
\alias{ohsome_query}
\title{Create an \code{ohsome_query} object}
\usage{
ohsome_query(endpoint, boundary = NULL, grouping = NULL, ..., validate = FALSE)
}
\arguments{
\item{endpoint}{The path to the
\href{https://docs.ohsome.org/ohsome-api/v1/endpoints.html}{ohsome API endpoint}.
Either a single string (e.g. \code{"elements/count"}) or a vector of character
in the right order (e.g. \code{c("elements", "count")}).}

\item{boundary}{Bounding geometries specified by WGS84 coordinates in the
order \verb{lon,lat}. The geometries of \code{sf} are transformed to WGS84 if the CRS
of the object is known. The following classes are supported:
\itemize{
\item \code{sf} with (MULTI)POLYGON geometries
\item \code{sfc} with (MULTI)POLYGON geometries
\item \code{sfg} with (MULTI)POLYGON geometries and WGS 84 coordinates
\item \code{bbox} created with \code{\link[sf:st_bbox]{sf::st_bbox()}} or \code{\link[tmaptools:bb]{tmaptools::bb()}}
\item \code{matrix} created with \code{\link[sp:bbox]{sp::bbox()}} or \code{\link[osmdata:getbb]{osmdata::getbb()}}
\item \code{character} providing textual definitions of bounding polygons, boxes or
circles as allowed by the ohsome API (see
\href{https://docs.ohsome.org/ohsome-api/stable/boundaries.html}{ohsome API - Boundaries}
):
\itemize{
\item bboxes: WGS84 coordinates in the following format:
\code{"id1:lon1,lat1,lon2,lat2|id2:lon1,lat1,lon2,lat2|..."} OR
\code{"lon1,lat1,lon2,lat2|lon1,lat1,lon2,lat2|..."}
\item bcircles: WGS84 coordinates + radius in meter in the following
format: \code{"id1:lon,lat,r|id2:lon,lat,r|..."} OR
\code{"lon,lat,r|lon,lat,r|..."}
\item bpolys: WGS84 coordinates given as a list of coordinate pairs (as for
bboxes) or GeoJSON FeatureCollection. The first point has to be the same
as the last point and MultiPolygons are only supported in GeoJSON.
}
\item \code{list} of \code{bbox}, \code{matrix} or \code{character}. Bounding geometry types of all
list elements must be the same. Does not work with GeoJSON
FeatureCollections.
}}

\item{grouping}{character; group type(s) for grouped aggregations (only
available for queries to aggregation endpoints). The following group types
are available:
\itemize{
\item \code{"boundary"} groups the result by the given boundaries that are defined
through any of the \code{boundary} query parameters.
\item \code{"key"} groups the result by the given keys that are defined through the
\code{groupByKeys} query parameter.
\item \code{"tag"} groups the result by the given tags that are defined through the
\code{groupByKey} and \code{groupByValues} query parameters.
\item \code{"type"} groups the result by OSM element type.
\item \code{c("boundary", "tag")} groups the result by the given boundaries and
tags.
}

Not all of these group types are accepted by all of the aggregation
endpoints. Check
\href{https://docs.ohsome.org/ohsome-api/v1/group-by.html}{Grouping}
for available group types.}

\item{...}{Parameters of the request to the ohsome API endpoint.}

\item{validate}{logical; if \code{TRUE}, issues warning for invalid endpoint or
invalid/missing query parameters.}
}
\value{
An \code{ohsome_query} object. The object can be sent to the ohsome API
with \code{\link[=ohsome_post]{ohsome_post()}}. It consists of the following elements:
\itemize{
\item \code{url}: The URL of the endpoint.
\item \code{encode}: The way the information is encoded and then posted to the
ohsome API. Set as \code{"form"}.
\item \code{body}: The parameters of the query such as \code{format}, \code{filter} or
\code{bpolys}.
}
}
\description{
Creates an \code{ohsome_query} object specifying the ohsome API endpoint and
the request parameters.
}
\examples{
# Extract building geometries with manually set bboxes parameter
ohsome_query(
    "elements/geometry", 
    bboxes = "8.6,49.36,8.75,49.44", 
    time = "2022-01-01",
    filter = "building=*"
)

# Extract building geometries using a boundary object:
ohsome_query(
    "elements/geometry", 
    boundary = "8.6,49.36,8.75,49.44", 
    time = "2022-01-01",
    filter = "building=*"
)

}
\seealso{
\href{https://docs.ohsome.org/ohsome-api/v1/}{ohsome API documentation}
}
