% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_methods.R
\name{ph_with_text}
\alias{ph_with_text}
\title{add text into a new shape}
\usage{
ph_with_text(x, str, type = "title", index = 1, location = NULL)
}
\arguments{
\item{x}{a pptx device}

\item{str}{text to add}

\item{type}{placeholder type (i.e. 'body', 'title')}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body', the first
one will be added with index 1 and the second one with index 2.
It is recommanded to use argument \code{location} instead of \code{type} and
\code{index}.}

\item{location}{a placeholder location object. This is a convenient
argument that can replace usage of arguments \code{type} and \code{index}.
See \link{ph_location_type}, \link{ph_location}, \link{ph_location_label},
\link{ph_location_left}, \link{ph_location_right}, \link{ph_location_fullsize}.}
}
\description{
add text into a new shape in a slide.
This function will be deprecated in favor of \code{\link{ph_with}}
in the next release.
}
\examples{
fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with_text(x = doc, type = "title", str = "Un titre")
doc <- ph_with_text(x = doc, type = "ftr", str = "pied de page")
doc <- ph_with_text(x = doc, type = "dt", str = format(Sys.Date()))
doc <- ph_with_text(x = doc, type = "sldNum", str = "slide 1")

doc <- add_slide(doc, layout = "Title Slide", master = "Office Theme")
doc <- ph_with_text(x = doc, type = "subTitle", str = "Un sous titre")
doc <- ph_with_text(x = doc, type = "ctrTitle", str = "Un titre")

print(doc, target = fileout )
}
