% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_add.R
\name{ph_add_par}
\alias{ph_add_par}
\title{append paragraph}
\usage{
ph_add_par(x, type = NULL, id_chr = NULL, level = 1,
  ph_label = NULL)
}
\arguments{
\item{x}{a pptx device}

\item{type}{placeholder type}

\item{id_chr}{placeholder id (a string). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.
Values can be read from \code{\link{slide_summary}}.}

\item{level}{paragraph level}

\item{ph_label}{label associated to the placeholder. Use column
\code{ph_label} of result returned by \code{\link{slide_summary}}.
This should be used instead of using \code{type} and \code{id_chr}.}
}
\description{
append a new empty paragraph in a placeholder
}
\examples{
library(magrittr)

fileout <- tempfile(fileext = ".pptx")
default_text <- fp_text(font.size = 0, bold = TRUE, color = "red")

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with_text(type = "body", str = "A text") \%>\%
  ph_add_par(level = 2) \%>\%
  ph_add_text(str = "and another, ", style = default_text ) \%>\%
  ph_add_par(level = 3) \%>\%
  ph_add_text(str = "and another!",
    style = update(default_text, color = "blue"))

print(doc, target = fileout)
}
