% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpptx_document.R
\name{rpptx_document}
\alias{rpptx_document}
\title{Advanced R Markdown PowerPoint Format}
\usage{
rpptx_document(
  base_format = "rmarkdown::powerpoint_presentation",
  layout = "Title and Content",
  master = "Office Theme",
  tcf = list(),
  ...
)
}
\arguments{
\item{base_format}{a scalar character, format to be used as a base document for
officedown. default to \link[rmarkdown:powerpoint_presentation]{powerpoint_presentation} but
can also be powerpoint_presentation2 from bookdown}

\item{layout}{default slide layout name to use}

\item{master}{default master layout name where \code{layout} is located}

\item{tcf}{default conditional formatting settings
defined by \code{\link[officer:table_conditional_formatting]{officer::table_conditional_formatting()}}}

\item{...}{arguments used by \link[rmarkdown:powerpoint_presentation]{powerpoint_presentation}}
}
\value{
R Markdown output format to pass to \link[rmarkdown:render]{render}
}
\description{
Format for converting from R Markdown to an MS PowerPoint
document. \code{rpptx_document2} also supports cross reference based on the
syntax of the bookdown package.

The function will allow you to specify the destination of your chunks in the output
PowerPoint file. In this case, you must specify the \code{layout} and \code{master} for the
layout you want to use, as well as the \code{ph} argument, which will allow you to specify
the placeholder to be generated to place the result. Use the officer package to help
you choose the identfiers to use.

This function also support Vector graphics output in an editable format (using package
\code{rvg}). Wrap you R plot commands with function \code{dml} to use this graphic capability.
}
\examples{
library(rmarkdown)
run_ok <- pandoc_available() && pandoc_version() > numeric_version("2.4")

if(run_ok){
  example <- system.file(package = "officedown",
    "examples/minimal_powerpoint.Rmd")
  rmd_file <- tempfile(fileext = ".Rmd")
  file.copy(example, to = rmd_file)

  pptx_file_1 <- tempfile(fileext = ".pptx")
  render(rmd_file, output_file = pptx_file_1)
}

if(run_ok && require("ggplot2")){
  skeleton <- system.file(package = "officedown",
    "rmarkdown/templates/powerpoint/skeleton/skeleton.Rmd")
  rmd_file <- tempfile(fileext = ".Rmd")
  file.copy(skeleton, to = rmd_file)

  pptx_file_2 <- tempfile(fileext = ".pptx")
  render(rmd_file, output_file = pptx_file_2)
}
}
