% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{oemfit}
\alias{cv.oemfit}
\alias{oem-deprecated}
\alias{oemfit}
\alias{plot.oemfit}
\alias{predict.oemfit}
\alias{print.oemfit}
\title{Deprecated functions}
\usage{
oemfit(formula, data = list(), lambda = NULL, nlambda = 100,
  lambda.min.ratio = NULL, tolerance = 0.001, maxIter = 1000,
  standardized = TRUE, numGroup = 1, penalty = c("lasso", "scad", "ols",
  "elastic.net", "ngarrote", "mcp"), alpha = 3, evaluate = 0,
  condition = -1)

cv.oemfit(formula, data = list(), lambda = NULL, type.measure = c("mse",
  "mae"), ..., nfolds = 10, foldid, penalty = c("lasso", "scad",
  "elastic.net", "ngarrote", "mcp"))

\method{plot}{oemfit}(x, xvar = c("norm", "lambda", "loglambda", "dev"),
  xlab = iname, ylab = "Coefficients", ...)

\method{predict}{oemfit}(object, newx, s = NULL, type = c("response",
  "coefficients", "nonzero"), ...)

\method{print}{oemfit}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{formula}{an object of 'formula' (or one that can be coerced to
that class): a symbolic description of the model to be fitted. The
details of model specification are given under 'Details'}

\item{data}{an optional data frame, list or environment (or object
coercible by 'as.data.frame' to a data frame) containing the
variables in the model.  If not found in 'data', the
variables are taken from 'environment(formula)', typically
the environment from which 'oemfit' is called.}

\item{lambda}{A user supplied \code{lambda} sequence. Typical usage is
to have the program compute its own \code{lambda} sequence based on
\code{nlambda} and \code{lambda.min.ratio}. Supplying a value of
\code{lambda} overrides this. WARNING: use with care. Do not supply a
single value for \code{lambda} (for predictions after CV use \code{predict()} 
instead).  Supply instead a decreasing sequence of \code{lambda}
values. \code{oemfit} relies on its warms starts for speed, and its
often faster to fit a whole path than compute a single fit.}

\item{nlambda}{The number of \code{lambda} values - default is 100.}

\item{lambda.min.ratio}{Smallest value for \code{lambda}, as a fraction of
\code{lambda.max}, the (data derived) entry value (i.e. the smallest
value for which all coefficients are zero). The default depends on the
sample size \code{nobs} relative to the number of variables
\code{nvars}. If \code{nobs > nvars}, the default is \code{0.0001},
close to zero.  If \code{nobs < nvars}, the default is \code{0.01}.
A very small value of
\code{lambda.min.ratio} will lead to a saturated fit in the \code{nobs <
nvars} case.}

\item{tolerance}{Convergence tolerance for OEM. Each inner
OEM loop continues until the maximum change in the
objective after any coefficient update is less than \code{tolerance}.
Defaults value is \code{1E-3}.}

\item{maxIter}{Maximum number of passes over the data for all lambda
values; default is 1000.}

\item{standardized}{Logical flag for x variable standardization, prior to
fitting the model sequence. The coefficients are always returned on
the original scale. Default is \code{standardize=TRUE}.
If variables are in the same units already, you might not wish to
standardize.}

\item{numGroup}{Integer value for the number of groups to use for OEM
fitting. Default is 1.}

\item{penalty}{type in lower letters. Different types include
'lasso', 'scad', 'ols' (ordinary least square), 'elastic-net',
'ngarrote' (non-negative garrote) and 'mcp'.}

\item{alpha}{alpha value for scad and mcp.}

\item{evaluate}{debugging argument}

\item{condition}{Debugging for different ways of calculating OEM.}

\item{type.measure}{type.measure measure to evaluate for cross-validation. 
\code{type.measure = "mse"} (mean squared error) or 
\code{type.measure = "mae"} (mean absolute error)}

\item{...}{arguments to be passed to \code{oemfit()}}

\item{nfolds}{number of folds for cross-validation. default is 10.}

\item{foldid}{an optional vector of values between 1 and nfold specifying which fold each observation belongs to.}

\item{x}{fitted \code{oemfit} object}

\item{xvar}{what is on the X-axis. "norm" plots against the L1-norm of the coefficients,
"lambda" against the log-lambda sequence, and "dev" against the percent deviance
explained.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{object}{fitted \code{oemfit} object}

\item{newx}{matrix of new values for x at which predictions are to be
made. Must be a matrix.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions
are required. Default is the entire sequence used to create the model.}

\item{type}{not used.}

\item{digits}{significant digits in print out.}
}
\description{
These functions have been renamed and deprecated in \pkg{oem}:
\code{oemfit()} (use \code{\link{oem}()}), \code{cv.oemfit()}
(use \code{\link{cv.oem}()}), \code{print.oemfit()}, 
\code{plot.oemfit()}, \code{predict.oemfit()}, and 
\code{coef.oemfit()}.
}
\details{
The sequence of models implied by 'lambda' is fit by OEM algorithm.
}
\author{
Bin Dai
}

