% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_check_response.R
\name{input_check_response}
\alias{input_check_response}
\title{Standardized response to input check}
\usage{
input_check_response(
  check,
  var_name = NULL,
  error = TRUE,
  prefix = "Input {.var {var_name}} is bad:"
)
}
\arguments{
\item{check}{[\code{TRUE} | \code{character(1)} | \code{list()}]\cr
Matches the return value of the \verb{check*} functions from the \code{{checkmate}}
package, i.e., either \code{TRUE} if the check was successful, or a \code{character}
(the error message) else.

Can also be a \code{list} of multiple such values for alternative criteria, where
at least one must be \code{TRUE} for a successful check.}

\item{var_name}{[\code{NULL} | \code{character(1)}]\cr
Optionally specifies the name of the input being checked. This name will be
used for the default value of the \code{prefix} argument.}

\item{error}{[\code{logical(1)}]\cr
If \code{check} is not \code{TRUE} (or no element in \code{check} is \code{TRUE}, if \code{check} is
a \code{list}), throw an error?}

\item{prefix}{[\code{character(1)}]\cr
A prefix for the thrown error message, only relevant if \code{error} is \code{TRUE}.}
}
\value{
\code{TRUE} if \code{check} is \code{TRUE} (or any element in \code{check} is \code{TRUE}, if \code{check}
is a \code{list}) . Else, depending on \code{error}:
\itemize{
\item If \code{error} is \code{TRUE}, throws an error.
\item If \code{error} is \code{FALSE}, returns \code{FALSE}.
}
}
\description{
This function provides a standardized response to input checks, ensuring
consistency.
}
\examples{
x <- "1"
y <- 1

### check is successful
input_check_response(
  check = checkmate::check_character(x),
  var_name = "x",
  error = TRUE
)

### alternative checks
input_check_response(
  check = list(
    checkmate::check_character(x),
    checkmate::check_character(y)
  ),
  var_name = "x",
  error = TRUE
)

### standardized check response
\dontrun{
input_check_response(
  check = checkmate::check_character(y),
  var_name = "y",
  error = TRUE
)

input_check_response(
  check = list(
    checkmate::check_flag(x),
    checkmate::check_character(y)
  ),
  var_name = "y",
  error = TRUE
)
}
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{check_missing}()},
\code{\link{identical_structure}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{print_matrix}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{packaging}
