% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timed_evaluation.R
\name{timed}
\alias{timed}
\title{Interrupt long evaluations}
\usage{
timed(expression, seconds = Inf, on_time_out = "silent")
}
\arguments{
\item{expression}{An R expression to be evaluated.}

\item{seconds}{The number of seconds.}

\item{on_time_out}{Defines what action to take if the evaluation time exceeded, either:
\itemize{
\item \code{"error"} to throw an error exception
\item \code{"warning"} to return \code{NULL} along with a warning
\item \code{"silent"} (the default) to just return \code{NULL}
}}
}
\value{
The value of \code{expression} or, if the evaluation time exceeded, whatever
is specified for \code{on_time_out}.
}
\description{
This function interrupts an evaluation after a certain number of seconds.
Note the limitations documented in \code{\link[base]{setTimeLimit}}.
}
\examples{
foo <- function(x) {
  for (i in 1:10) Sys.sleep(x / 10)
  return(x)
}
timed(foo(0.5), 1)
timed(foo(1.5), 1)

}
