% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.ratio.glm.R
\name{calc.oddsratio.glm}
\alias{calc.oddsratio.glm}
\title{Calculate Odds Ratio of Generalized Linear (Mixed) Models}
\usage{
calc.oddsratio.glm(data, model, incr)
}
\arguments{
\item{data}{The data used for model fitting.}

\item{model}{A fitted GLM(M).}

\item{incr}{List. Increment values of each predictor.}
}
\value{
A data frame with three columns:
\item{predictor}{Predictor name(s)}
\item{oddsratio}{Calculated odds ratio(s)}
\item{increment}{Increment of the predictor(s)}
}
\description{
This function calculates odds ratio(s) for specific 
    increment steps of GLMs.
}
\details{
Currently supported functions: \code{\link[stats]{glm}}, 
\code{\link[MASS]{glmmPQL}}
}
\examples{
## Example with stats::glm()
# load data (Data source: http://www.ats.ucla.edu/stat/r/dae/logit.htm)
dat <- read.csv("http://www.ats.ucla.edu/stat/data/binary.csv")
dat$rank <- factor(dat$rank)
fit.glm <- glm(admit ~ gre + gpa + rank, data = dat, family = "binomial") # fit model

# Calculate OR for specific increment step of continuous variable
calc.oddsratio.glm(data = dat, model = fit.glm, incr = list(gre = 380, gpa = 5))

## Example with MASS:glmmPQL()
# load data
library(MASS)
data(bacteria)
fit.glmmPQL <- MASS::glmmPQL(y ~ trt + week, random = ~1 | ID,
                             family = binomial, data = bacteria, verbose = FALSE)

# Apply function
calc.oddsratio.glm(data = bacteria, model = fit.glmmPQL, incr = list(week = 5))

}
\seealso{
\code{\link[oddsratio]{calc.oddsratio.gam}}
}

