% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-config.R
\name{odbcListConfig}
\alias{odbcListConfig}
\title{List locations of ODBC configuration files}
\usage{
odbcListConfig()
}
\description{
On MacOS and Linux, odbc uses the unixODBC driver manager to manage
information about driver and data sources. This helper returns the filepaths
where the driver manager will look for that information.

This function is a wrapper around the command line call \code{odbcinst -j}.

Windows does not use \code{.ini} configuration files; this function will return a
0-length vector on Windows.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
configs <- odbcListConfig()

file.edit(configs[1])
\dontshow{\}) # examplesIf}
}
\seealso{
The \code{\link[=odbcListDrivers]{odbcListDrivers()}} and \code{\link[=odbcListDataSources]{odbcListDataSources()}} helpers return
information on the contents of \code{odbcinst.ini} and \code{odbc.ini} files,
respectively.

Learn more about unixODBC and the \code{odbcinst} utility
\href{https://www.unixodbc.org/odbcinst.html}{here}.
}
