% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfunctions.R
\name{plot.oclust}
\alias{plot.oclust}
\title{Plots results of the \sQuote{oclust} algorithm.}
\usage{
\method{plot}{oclust}(
  x,
  what = c("classification", "KL", "pval"),
  dimens = NULL,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  addEllipses = TRUE,
  ...
)
}
\arguments{
\item{x}{An \sQuote{oclust} class object obtained by using \code{\link{oclust}}}

\item{what}{A string specifying the type of graph. The options are:
"classification"    a plot of the classifications for the optimal solution.
For data with p>2, if more than two "dimens" are specified, a pairs plot is produced. If two "dimens" are specified,  a coordinate projection plot is produced with the specified "dimens".
Ellipses corresponding to covariances of mixture components are also drawn if "addEllipses = TRUE".
"KL"    a plot of Kullback-Leibler divergence for each number of outliers.
"pval"    a plot of approximate p-value for each number of outliers.}

\item{dimens}{a vector specifying the dimensions of the coordinate projections}

\item{xlab, ylab}{optional argument specifying axis labels for the classsification plot}

\item{ylim}{optional limits of the y axis of the BIC and KL plots}

\item{addEllipses}{logical indicating whether to include ellipses corresponding
to the covariances of the mixture components}

\item{...}{other graphical parameters}
}
\description{
Plots results of the \sQuote{oclust} algorithm.
}
