% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceCoxph.R
\name{oceCoxph}
\alias{oceCoxph}
\title{Estimate win ratio or Mann-Whitney parameter using Cox Proportional Hazards}
\usage{
oceCoxph(oceData)
}
\arguments{
\item{oceData}{output from \code{\link{oceFormat}}}
}
\value{
An \code{oceCoxph} object, which is a list with the following
elements (where Yg=ordered composite endpoint score for group=g):
\describe{
 \item{oceNames}{long names for each of the ordered endpoints}
 \item{TAU}{maximum of all the time-to-event variables (even censored ones)}
 \item{coxOutput}{output from coxph function}
 \item{int01}{estimate of P[Y0>Y1]}
 \item{int10}{estimate of P[Y1>Y0]}
 \item{WR}{win ratio, estimate of P[Y1>Y0]/P[Y0>Y1]}
 \item{MW}{desirability of outcome ranking,
    estimate of P[Y1>Y0]+(1/2)P[Y1=Y0]}
 }
}
\description{
Usually called from within \code{\link{oceTest}}, but useful for
getting \code{coxph} output details or customizing graphics. Estimation done using
coxph (partial likelihood methods).
}
\seealso{
For an example using plotting see \code{\link{plot.oceCoxph}}.
 For Cox regression with other covariates, see
\code{vignette("Using oceCens",package="oceCens")}.
}
