% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astronomy.R
\name{julianCenturyAnomaly}
\alias{julianCenturyAnomaly}
\title{Convert Julian-Day-Number to Julian Century}
\usage{
julianCenturyAnomaly(jd)
}
\arguments{
\item{jd}{a julian day number, e.g. as given by \code{\link[=julianDay]{julianDay()}}.}
}
\value{
Julian century since noon on January 1, 1900.
}
\description{
Convert a Julian-Day number to a time in julian centuries since noon on
January 1, 1900.
The method follows reference 1 equation 15.1.  The example reproduces the
example provided by reference 1 example 15.a, with fractional error 3e-8.
}
\examples{

t <- ISOdatetime(1978, 11, 13, 4, 35, 0, tz = "UTC")
jca <- julianCenturyAnomaly(julianDay(t))
cat(format(t), "is Julian Century anomaly", format(jca, digits = 8), "\n")

}
\references{
\itemize{
\item Meeus, Jean. Astronomical Formulas for Calculators. Second Edition.
Richmond, Virginia, USA: Willmann-Bell, 1982.
}
}
\seealso{
Other things related to astronomy: 
\code{\link{angle2hms}()},
\code{\link{eclipticalToEquatorial}()},
\code{\link{equatorialToLocalHorizontal}()},
\code{\link{julianDay}()},
\code{\link{moonAngle}()},
\code{\link{siderealTime}()},
\code{\link{sunAngle}()},
\code{\link{sunDeclinationRightAscension}()}

Other things related to time: 
\code{\link{ctimeToSeconds}()},
\code{\link{julianDay}()},
\code{\link{numberAsHMS}()},
\code{\link{numberAsPOSIXct}()},
\code{\link{secondsToCtime}()},
\code{\link{unabbreviateYear}()}
}
\author{
Dan Kelley
}
\concept{things related to astronomy}
\concept{things related to time}
